/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionListingCopier;
import software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisioningTemplateVersionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListProvisioningTemplateVersionsResponse> {
    private static final SdkField<List<ProvisioningTemplateVersionSummary>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("versions").getter(ListProvisioningTemplateVersionsResponse.getter(ListProvisioningTemplateVersionsResponse::versions)).setter(ListProvisioningTemplateVersionsResponse.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningTemplateVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProvisioningTemplateVersionsResponse.getter(ListProvisioningTemplateVersionsResponse::nextToken)).setter(ListProvisioningTemplateVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ProvisioningTemplateVersionSummary> versions;
    private final String nextToken;

    private ListProvisioningTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.versions = builder.versions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVersions() {
        return this.versions != null && !(this.versions instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningTemplateVersionSummary> versions() {
        return this.versions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersions() ? this.versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningTemplateVersionsResponse)) {
            return false;
        }
        ListProvisioningTemplateVersionsResponse other = (ListProvisioningTemplateVersionsResponse)((Object)obj);
        return this.hasVersions() == other.hasVersions() && Objects.equals(this.versions(), other.versions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProvisioningTemplateVersionsResponse").add("Versions", this.hasVersions() ? this.versions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisioningTemplateVersionsResponse, T> g) {
        return obj -> g.apply((ListProvisioningTemplateVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ProvisioningTemplateVersionSummary> versions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningTemplateVersionsResponse model) {
            super(model);
            this.versions(model.versions);
            this.nextToken(model.nextToken);
        }

        public final List<ProvisioningTemplateVersionSummary.Builder> getVersions() {
            List<ProvisioningTemplateVersionSummary.Builder> result = ProvisioningTemplateVersionListingCopier.copyToBuilder(this.versions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVersions(Collection<ProvisioningTemplateVersionSummary.BuilderImpl> versions) {
            this.versions = ProvisioningTemplateVersionListingCopier.copyFromBuilder(versions);
        }

        @Override
        @Transient
        public final Builder versions(Collection<ProvisioningTemplateVersionSummary> versions) {
            this.versions = ProvisioningTemplateVersionListingCopier.copy(versions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(ProvisioningTemplateVersionSummary ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(Consumer<ProvisioningTemplateVersionSummary.Builder> ... versions) {
            this.versions(Stream.of(versions).map(c -> (ProvisioningTemplateVersionSummary)((ProvisioningTemplateVersionSummary.Builder)ProvisioningTemplateVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProvisioningTemplateVersionsResponse build() {
            return new ListProvisioningTemplateVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisioningTemplateVersionsResponse> {
        public Builder versions(Collection<ProvisioningTemplateVersionSummary> var1);

        public Builder versions(ProvisioningTemplateVersionSummary ... var1);

        public Builder versions(Consumer<ProvisioningTemplateVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

