/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThing;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse;

public class ListJobExecutionsForThingIterable
implements SdkIterable<ListJobExecutionsForThingResponse> {
    private final IotClient client;
    private final ListJobExecutionsForThingRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobExecutionsForThingIterable(IotClient client, ListJobExecutionsForThingRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListJobExecutionsForThingResponseFetcher();
    }

    public Iterator<ListJobExecutionsForThingResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobExecutionSummaryForThing> executionSummaries() {
        Function<ListJobExecutionsForThingResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionSummaries() != null) {
                return response.executionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobExecutionsForThingResponseFetcher
    implements SyncPageFetcher<ListJobExecutionsForThingResponse> {
        private ListJobExecutionsForThingResponseFetcher() {
        }

        public boolean hasNextPage(ListJobExecutionsForThingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobExecutionsForThingResponse nextPage(ListJobExecutionsForThingResponse previousPage) {
            if (previousPage == null) {
                return ListJobExecutionsForThingIterable.this.client.listJobExecutionsForThing(ListJobExecutionsForThingIterable.this.firstRequest);
            }
            return ListJobExecutionsForThingIterable.this.client.listJobExecutionsForThing((ListJobExecutionsForThingRequest)((Object)ListJobExecutionsForThingIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

