/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.RegistrationConfig;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterCaCertificateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, RegisterCaCertificateRequest> {
    private static final SdkField<String> CA_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caCertificate").getter(RegisterCaCertificateRequest.getter(RegisterCaCertificateRequest::caCertificate)).setter(RegisterCaCertificateRequest.setter(Builder::caCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificate").build()}).build();
    private static final SdkField<String> VERIFICATION_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("verificationCertificate").getter(RegisterCaCertificateRequest.getter(RegisterCaCertificateRequest::verificationCertificate)).setter(RegisterCaCertificateRequest.setter(Builder::verificationCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationCertificate").build()}).build();
    private static final SdkField<Boolean> SET_AS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("setAsActive").getter(RegisterCaCertificateRequest.getter(RegisterCaCertificateRequest::setAsActive)).setter(RegisterCaCertificateRequest.setter(Builder::setAsActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("setAsActive").build()}).build();
    private static final SdkField<Boolean> ALLOW_AUTO_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowAutoRegistration").getter(RegisterCaCertificateRequest.getter(RegisterCaCertificateRequest::allowAutoRegistration)).setter(RegisterCaCertificateRequest.setter(Builder::allowAutoRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("allowAutoRegistration").build()}).build();
    private static final SdkField<RegistrationConfig> REGISTRATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("registrationConfig").getter(RegisterCaCertificateRequest.getter(RegisterCaCertificateRequest::registrationConfig)).setter(RegisterCaCertificateRequest.setter(Builder::registrationConfig)).constructor(RegistrationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(RegisterCaCertificateRequest.getter(RegisterCaCertificateRequest::tags)).setter(RegisterCaCertificateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CA_CERTIFICATE_FIELD, VERIFICATION_CERTIFICATE_FIELD, SET_AS_ACTIVE_FIELD, ALLOW_AUTO_REGISTRATION_FIELD, REGISTRATION_CONFIG_FIELD, TAGS_FIELD));
    private final String caCertificate;
    private final String verificationCertificate;
    private final Boolean setAsActive;
    private final Boolean allowAutoRegistration;
    private final RegistrationConfig registrationConfig;
    private final List<Tag> tags;

    private RegisterCaCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.caCertificate = builder.caCertificate;
        this.verificationCertificate = builder.verificationCertificate;
        this.setAsActive = builder.setAsActive;
        this.allowAutoRegistration = builder.allowAutoRegistration;
        this.registrationConfig = builder.registrationConfig;
        this.tags = builder.tags;
    }

    public final String caCertificate() {
        return this.caCertificate;
    }

    public final String verificationCertificate() {
        return this.verificationCertificate;
    }

    public final Boolean setAsActive() {
        return this.setAsActive;
    }

    public final Boolean allowAutoRegistration() {
        return this.allowAutoRegistration;
    }

    public final RegistrationConfig registrationConfig() {
        return this.registrationConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.setAsActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowAutoRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCaCertificateRequest)) {
            return false;
        }
        RegisterCaCertificateRequest other = (RegisterCaCertificateRequest)((Object)obj);
        return Objects.equals(this.caCertificate(), other.caCertificate()) && Objects.equals(this.verificationCertificate(), other.verificationCertificate()) && Objects.equals(this.setAsActive(), other.setAsActive()) && Objects.equals(this.allowAutoRegistration(), other.allowAutoRegistration()) && Objects.equals(this.registrationConfig(), other.registrationConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterCaCertificateRequest").add("CaCertificate", (Object)this.caCertificate()).add("VerificationCertificate", (Object)this.verificationCertificate()).add("SetAsActive", (Object)this.setAsActive()).add("AllowAutoRegistration", (Object)this.allowAutoRegistration()).add("RegistrationConfig", (Object)this.registrationConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caCertificate": {
                return Optional.ofNullable(clazz.cast(this.caCertificate()));
            }
            case "verificationCertificate": {
                return Optional.ofNullable(clazz.cast(this.verificationCertificate()));
            }
            case "setAsActive": {
                return Optional.ofNullable(clazz.cast(this.setAsActive()));
            }
            case "allowAutoRegistration": {
                return Optional.ofNullable(clazz.cast(this.allowAutoRegistration()));
            }
            case "registrationConfig": {
                return Optional.ofNullable(clazz.cast(this.registrationConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterCaCertificateRequest, T> g) {
        return obj -> g.apply((RegisterCaCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String caCertificate;
        private String verificationCertificate;
        private Boolean setAsActive;
        private Boolean allowAutoRegistration;
        private RegistrationConfig registrationConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCaCertificateRequest model) {
            super(model);
            this.caCertificate(model.caCertificate);
            this.verificationCertificate(model.verificationCertificate);
            this.setAsActive(model.setAsActive);
            this.allowAutoRegistration(model.allowAutoRegistration);
            this.registrationConfig(model.registrationConfig);
            this.tags(model.tags);
        }

        public final String getCaCertificate() {
            return this.caCertificate;
        }

        public final void setCaCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
        }

        @Override
        @Transient
        public final Builder caCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        public final String getVerificationCertificate() {
            return this.verificationCertificate;
        }

        public final void setVerificationCertificate(String verificationCertificate) {
            this.verificationCertificate = verificationCertificate;
        }

        @Override
        @Transient
        public final Builder verificationCertificate(String verificationCertificate) {
            this.verificationCertificate = verificationCertificate;
            return this;
        }

        public final Boolean getSetAsActive() {
            return this.setAsActive;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        @Override
        @Transient
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final Boolean getAllowAutoRegistration() {
            return this.allowAutoRegistration;
        }

        public final void setAllowAutoRegistration(Boolean allowAutoRegistration) {
            this.allowAutoRegistration = allowAutoRegistration;
        }

        @Override
        @Transient
        public final Builder allowAutoRegistration(Boolean allowAutoRegistration) {
            this.allowAutoRegistration = allowAutoRegistration;
            return this;
        }

        public final RegistrationConfig.Builder getRegistrationConfig() {
            return this.registrationConfig != null ? this.registrationConfig.toBuilder() : null;
        }

        public final void setRegistrationConfig(RegistrationConfig.BuilderImpl registrationConfig) {
            this.registrationConfig = registrationConfig != null ? registrationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder registrationConfig(RegistrationConfig registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterCaCertificateRequest build() {
            return new RegisterCaCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterCaCertificateRequest> {
        public Builder caCertificate(String var1);

        public Builder verificationCertificate(String var1);

        public Builder setAsActive(Boolean var1);

        public Builder allowAutoRegistration(Boolean var1);

        public Builder registrationConfig(RegistrationConfig var1);

        default public Builder registrationConfig(Consumer<RegistrationConfig.Builder> registrationConfig) {
            return this.registrationConfig((RegistrationConfig)((RegistrationConfig.Builder)RegistrationConfig.builder().applyMutation(registrationConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

