/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAuthorizerResponse
extends IotResponse
implements ToCopyableBuilder<Builder, UpdateAuthorizerResponse> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerName").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::authorizerName)).setter(UpdateAuthorizerResponse.setter(Builder::authorizerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerName").build()}).build();
    private static final SdkField<String> AUTHORIZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerArn").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::authorizerArn)).setter(UpdateAuthorizerResponse.setter(Builder::authorizerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD, AUTHORIZER_ARN_FIELD));
    private final String authorizerName;
    private final String authorizerArn;

    private UpdateAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.authorizerName = builder.authorizerName;
        this.authorizerArn = builder.authorizerArn;
    }

    public final String authorizerName() {
        return this.authorizerName;
    }

    public final String authorizerArn() {
        return this.authorizerArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuthorizerResponse)) {
            return false;
        }
        UpdateAuthorizerResponse other = (UpdateAuthorizerResponse)((Object)obj);
        return Objects.equals(this.authorizerName(), other.authorizerName()) && Objects.equals(this.authorizerArn(), other.authorizerArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAuthorizerResponse").add("AuthorizerName", (Object)this.authorizerName()).add("AuthorizerArn", (Object)this.authorizerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizerName": {
                return Optional.ofNullable(clazz.cast(this.authorizerName()));
            }
            case "authorizerArn": {
                return Optional.ofNullable(clazz.cast(this.authorizerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuthorizerResponse, T> g) {
        return obj -> g.apply((UpdateAuthorizerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String authorizerName;
        private String authorizerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuthorizerResponse model) {
            super(model);
            this.authorizerName(model.authorizerName);
            this.authorizerArn(model.authorizerArn);
        }

        public final String getAuthorizerName() {
            return this.authorizerName;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        @Override
        @Transient
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final String getAuthorizerArn() {
            return this.authorizerArn;
        }

        public final void setAuthorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
        }

        @Override
        @Transient
        public final Builder authorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
            return this;
        }

        @Override
        public UpdateAuthorizerResponse build() {
            return new UpdateAuthorizerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAuthorizerResponse> {
        public Builder authorizerName(String var1);

        public Builder authorizerArn(String var1);
    }
}

