/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.TargetAuditCheckNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartOnDemandAuditTaskRequest
extends IotRequest
implements ToCopyableBuilder<Builder, StartOnDemandAuditTaskRequest> {
    private static final SdkField<List<String>> TARGET_CHECK_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetCheckNames").getter(StartOnDemandAuditTaskRequest.getter(StartOnDemandAuditTaskRequest::targetCheckNames)).setter(StartOnDemandAuditTaskRequest.setter(Builder::targetCheckNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCheckNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_CHECK_NAMES_FIELD));
    private final List<String> targetCheckNames;

    private StartOnDemandAuditTaskRequest(BuilderImpl builder) {
        super(builder);
        this.targetCheckNames = builder.targetCheckNames;
    }

    public final boolean hasTargetCheckNames() {
        return this.targetCheckNames != null && !(this.targetCheckNames instanceof SdkAutoConstructList);
    }

    public final List<String> targetCheckNames() {
        return this.targetCheckNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetCheckNames() ? this.targetCheckNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOnDemandAuditTaskRequest)) {
            return false;
        }
        StartOnDemandAuditTaskRequest other = (StartOnDemandAuditTaskRequest)((Object)obj);
        return this.hasTargetCheckNames() == other.hasTargetCheckNames() && Objects.equals(this.targetCheckNames(), other.targetCheckNames());
    }

    public final String toString() {
        return ToString.builder((String)"StartOnDemandAuditTaskRequest").add("TargetCheckNames", this.hasTargetCheckNames() ? this.targetCheckNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetCheckNames": {
                return Optional.ofNullable(clazz.cast(this.targetCheckNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartOnDemandAuditTaskRequest, T> g) {
        return obj -> g.apply((StartOnDemandAuditTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private List<String> targetCheckNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartOnDemandAuditTaskRequest model) {
            super(model);
            this.targetCheckNames(model.targetCheckNames);
        }

        public final Collection<String> getTargetCheckNames() {
            if (this.targetCheckNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetCheckNames;
        }

        public final void setTargetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
        }

        @Override
        @Transient
        public final Builder targetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetCheckNames(String ... targetCheckNames) {
            this.targetCheckNames(Arrays.asList(targetCheckNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOnDemandAuditTaskRequest build() {
            return new StartOnDemandAuditTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartOnDemandAuditTaskRequest> {
        public Builder targetCheckNames(Collection<String> var1);

        public Builder targetCheckNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

