/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse;
import software.amazon.awssdk.services.iot.model.Policy;

public class ListAttachedPoliciesPublisher
implements SdkPublisher<ListAttachedPoliciesResponse> {
    private final IotAsyncClient client;
    private final ListAttachedPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachedPoliciesPublisher(IotAsyncClient client, ListAttachedPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachedPoliciesPublisher(IotAsyncClient client, ListAttachedPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachedPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachedPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Policy> policies() {
        Function<ListAttachedPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttachedPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAttachedPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAttachedPoliciesResponse> {
        private ListAttachedPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListAttachedPoliciesResponse> nextPage(ListAttachedPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedPoliciesPublisher.this.client.listAttachedPolicies(ListAttachedPoliciesPublisher.this.firstRequest);
            }
            return ListAttachedPoliciesPublisher.this.client.listAttachedPolicies((ListAttachedPoliciesRequest)((Object)ListAttachedPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

