/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AbortConfig;
import software.amazon.awssdk.services.iot.model.JobExecutionsRetryConfig;
import software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig;
import software.amazon.awssdk.services.iot.model.JobProcessDetails;
import software.amazon.awssdk.services.iot.model.JobStatus;
import software.amazon.awssdk.services.iot.model.JobTargetsCopier;
import software.amazon.awssdk.services.iot.model.ParameterMapCopier;
import software.amazon.awssdk.services.iot.model.PresignedUrlConfig;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.services.iot.model.TimeoutConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Job> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(Job.getter(Job::jobArn)).setter(Job.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(Job.getter(Job::jobId)).setter(Job.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetSelection").getter(Job.getter(Job::targetSelectionAsString)).setter(Job.setter(Builder::targetSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Job.getter(Job::statusAsString)).setter(Job.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> FORCE_CANCELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceCanceled").getter(Job.getter(Job::forceCanceled)).setter(Job.setter(Builder::forceCanceled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceCanceled").build()}).build();
    private static final SdkField<String> REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reasonCode").getter(Job.getter(Job::reasonCode)).setter(Job.setter(Builder::reasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonCode").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(Job.getter(Job::comment)).setter(Job.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(Job.getter(Job::targets)).setter(Job.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Job.getter(Job::description)).setter(Job.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<PresignedUrlConfig> PRESIGNED_URL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("presignedUrlConfig").getter(Job.getter(Job::presignedUrlConfig)).setter(Job.setter(Builder::presignedUrlConfig)).constructor(PresignedUrlConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlConfig").build()}).build();
    private static final SdkField<JobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobExecutionsRolloutConfig").getter(Job.getter(Job::jobExecutionsRolloutConfig)).setter(Job.setter(Builder::jobExecutionsRolloutConfig)).constructor(JobExecutionsRolloutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build()}).build();
    private static final SdkField<AbortConfig> ABORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("abortConfig").getter(Job.getter(Job::abortConfig)).setter(Job.setter(Builder::abortConfig)).constructor(AbortConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Job.getter(Job::createdAt)).setter(Job.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(Job.getter(Job::lastUpdatedAt)).setter(Job.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(Job.getter(Job::completedAt)).setter(Job.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final SdkField<JobProcessDetails> JOB_PROCESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobProcessDetails").getter(Job.getter(Job::jobProcessDetails)).setter(Job.setter(Builder::jobProcessDetails)).constructor(JobProcessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobProcessDetails").build()}).build();
    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeoutConfig").getter(Job.getter(Job::timeoutConfig)).setter(Job.setter(Builder::timeoutConfig)).constructor(TimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceId").getter(Job.getter(Job::namespaceId)).setter(Job.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceId").build()}).build();
    private static final SdkField<String> JOB_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobTemplateArn").getter(Job.getter(Job::jobTemplateArn)).setter(Job.setter(Builder::jobTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateArn").build()}).build();
    private static final SdkField<JobExecutionsRetryConfig> JOB_EXECUTIONS_RETRY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobExecutionsRetryConfig").getter(Job.getter(Job::jobExecutionsRetryConfig)).setter(Job.setter(Builder::jobExecutionsRetryConfig)).constructor(JobExecutionsRetryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRetryConfig").build()}).build();
    private static final SdkField<Map<String, String>> DOCUMENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("documentParameters").getter(Job.getter(Job::documentParameters)).setter(Job.setter(Builder::documentParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_ID_FIELD, TARGET_SELECTION_FIELD, STATUS_FIELD, FORCE_CANCELED_FIELD, REASON_CODE_FIELD, COMMENT_FIELD, TARGETS_FIELD, DESCRIPTION_FIELD, PRESIGNED_URL_CONFIG_FIELD, JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, COMPLETED_AT_FIELD, JOB_PROCESS_DETAILS_FIELD, TIMEOUT_CONFIG_FIELD, NAMESPACE_ID_FIELD, JOB_TEMPLATE_ARN_FIELD, JOB_EXECUTIONS_RETRY_CONFIG_FIELD, DOCUMENT_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobArn;
    private final String jobId;
    private final String targetSelection;
    private final String status;
    private final Boolean forceCanceled;
    private final String reasonCode;
    private final String comment;
    private final List<String> targets;
    private final String description;
    private final PresignedUrlConfig presignedUrlConfig;
    private final JobExecutionsRolloutConfig jobExecutionsRolloutConfig;
    private final AbortConfig abortConfig;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Instant completedAt;
    private final JobProcessDetails jobProcessDetails;
    private final TimeoutConfig timeoutConfig;
    private final String namespaceId;
    private final String jobTemplateArn;
    private final JobExecutionsRetryConfig jobExecutionsRetryConfig;
    private final Map<String, String> documentParameters;

    private Job(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.targetSelection = builder.targetSelection;
        this.status = builder.status;
        this.forceCanceled = builder.forceCanceled;
        this.reasonCode = builder.reasonCode;
        this.comment = builder.comment;
        this.targets = builder.targets;
        this.description = builder.description;
        this.presignedUrlConfig = builder.presignedUrlConfig;
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.completedAt = builder.completedAt;
        this.jobProcessDetails = builder.jobProcessDetails;
        this.timeoutConfig = builder.timeoutConfig;
        this.namespaceId = builder.namespaceId;
        this.jobTemplateArn = builder.jobTemplateArn;
        this.jobExecutionsRetryConfig = builder.jobExecutionsRetryConfig;
        this.documentParameters = builder.documentParameters;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public final String targetSelectionAsString() {
        return this.targetSelection;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean forceCanceled() {
        return this.forceCanceled;
    }

    public final String reasonCode() {
        return this.reasonCode;
    }

    public final String comment() {
        return this.comment;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public final String description() {
        return this.description;
    }

    public final PresignedUrlConfig presignedUrlConfig() {
        return this.presignedUrlConfig;
    }

    public final JobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return this.jobExecutionsRolloutConfig;
    }

    public final AbortConfig abortConfig() {
        return this.abortConfig;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final JobProcessDetails jobProcessDetails() {
        return this.jobProcessDetails;
    }

    public final TimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public final String namespaceId() {
        return this.namespaceId;
    }

    public final String jobTemplateArn() {
        return this.jobTemplateArn;
    }

    public final JobExecutionsRetryConfig jobExecutionsRetryConfig() {
        return this.jobExecutionsRetryConfig;
    }

    public final boolean hasDocumentParameters() {
        return this.documentParameters != null && !(this.documentParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> documentParameters() {
        return this.documentParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceCanceled());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobProcessDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionsRetryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentParameters() ? this.documentParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.forceCanceled(), other.forceCanceled()) && Objects.equals(this.reasonCode(), other.reasonCode()) && Objects.equals(this.comment(), other.comment()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.presignedUrlConfig(), other.presignedUrlConfig()) && Objects.equals(this.jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig()) && Objects.equals(this.abortConfig(), other.abortConfig()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.jobProcessDetails(), other.jobProcessDetails()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig()) && Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.jobTemplateArn(), other.jobTemplateArn()) && Objects.equals(this.jobExecutionsRetryConfig(), other.jobExecutionsRetryConfig()) && this.hasDocumentParameters() == other.hasDocumentParameters() && Objects.equals(this.documentParameters(), other.documentParameters());
    }

    public final String toString() {
        return ToString.builder((String)"Job").add("JobArn", (Object)this.jobArn()).add("JobId", (Object)this.jobId()).add("TargetSelection", (Object)this.targetSelectionAsString()).add("Status", (Object)this.statusAsString()).add("ForceCanceled", (Object)this.forceCanceled()).add("ReasonCode", (Object)this.reasonCode()).add("Comment", (Object)this.comment()).add("Targets", this.hasTargets() ? this.targets() : null).add("Description", (Object)this.description()).add("PresignedUrlConfig", (Object)this.presignedUrlConfig()).add("JobExecutionsRolloutConfig", (Object)this.jobExecutionsRolloutConfig()).add("AbortConfig", (Object)this.abortConfig()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("CompletedAt", (Object)this.completedAt()).add("JobProcessDetails", (Object)this.jobProcessDetails()).add("TimeoutConfig", (Object)this.timeoutConfig()).add("NamespaceId", (Object)this.namespaceId()).add("JobTemplateArn", (Object)this.jobTemplateArn()).add("JobExecutionsRetryConfig", (Object)this.jobExecutionsRetryConfig()).add("DocumentParameters", this.hasDocumentParameters() ? this.documentParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "forceCanceled": {
                return Optional.ofNullable(clazz.cast(this.forceCanceled()));
            }
            case "reasonCode": {
                return Optional.ofNullable(clazz.cast(this.reasonCode()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "presignedUrlConfig": {
                return Optional.ofNullable(clazz.cast(this.presignedUrlConfig()));
            }
            case "jobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionsRolloutConfig()));
            }
            case "abortConfig": {
                return Optional.ofNullable(clazz.cast(this.abortConfig()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "jobProcessDetails": {
                return Optional.ofNullable(clazz.cast(this.jobProcessDetails()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
            case "namespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
            case "jobTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.jobTemplateArn()));
            }
            case "jobExecutionsRetryConfig": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionsRetryConfig()));
            }
            case "documentParameters": {
                return Optional.ofNullable(clazz.cast(this.documentParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobId;
        private String targetSelection;
        private String status;
        private Boolean forceCanceled;
        private String reasonCode;
        private String comment;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private PresignedUrlConfig presignedUrlConfig;
        private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;
        private AbortConfig abortConfig;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Instant completedAt;
        private JobProcessDetails jobProcessDetails;
        private TimeoutConfig timeoutConfig;
        private String namespaceId;
        private String jobTemplateArn;
        private JobExecutionsRetryConfig jobExecutionsRetryConfig;
        private Map<String, String> documentParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.jobArn(model.jobArn);
            this.jobId(model.jobId);
            this.targetSelection(model.targetSelection);
            this.status(model.status);
            this.forceCanceled(model.forceCanceled);
            this.reasonCode(model.reasonCode);
            this.comment(model.comment);
            this.targets(model.targets);
            this.description(model.description);
            this.presignedUrlConfig(model.presignedUrlConfig);
            this.jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            this.abortConfig(model.abortConfig);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.completedAt(model.completedAt);
            this.jobProcessDetails(model.jobProcessDetails);
            this.timeoutConfig(model.timeoutConfig);
            this.namespaceId(model.namespaceId);
            this.jobTemplateArn(model.jobTemplateArn);
            this.jobExecutionsRetryConfig(model.jobExecutionsRetryConfig);
            this.documentParameters(model.documentParameters);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection == null ? null : targetSelection.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getForceCanceled() {
            return this.forceCanceled;
        }

        public final void setForceCanceled(Boolean forceCanceled) {
            this.forceCanceled = forceCanceled;
        }

        @Override
        public final Builder forceCanceled(Boolean forceCanceled) {
            this.forceCanceled = forceCanceled;
            return this;
        }

        public final String getReasonCode() {
            return this.reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PresignedUrlConfig.Builder getPresignedUrlConfig() {
            return this.presignedUrlConfig != null ? this.presignedUrlConfig.toBuilder() : null;
        }

        public final void setPresignedUrlConfig(PresignedUrlConfig.BuilderImpl presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig != null ? presignedUrlConfig.build() : null;
        }

        @Override
        public final Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        public final JobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return this.jobExecutionsRolloutConfig != null ? this.jobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final AbortConfig.Builder getAbortConfig() {
            return this.abortConfig != null ? this.abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(AbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        public final Builder abortConfig(AbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final JobProcessDetails.Builder getJobProcessDetails() {
            return this.jobProcessDetails != null ? this.jobProcessDetails.toBuilder() : null;
        }

        public final void setJobProcessDetails(JobProcessDetails.BuilderImpl jobProcessDetails) {
            this.jobProcessDetails = jobProcessDetails != null ? jobProcessDetails.build() : null;
        }

        @Override
        public final Builder jobProcessDetails(JobProcessDetails jobProcessDetails) {
            this.jobProcessDetails = jobProcessDetails;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getJobTemplateArn() {
            return this.jobTemplateArn;
        }

        public final void setJobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
        }

        @Override
        public final Builder jobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
            return this;
        }

        public final JobExecutionsRetryConfig.Builder getJobExecutionsRetryConfig() {
            return this.jobExecutionsRetryConfig != null ? this.jobExecutionsRetryConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRetryConfig(JobExecutionsRetryConfig.BuilderImpl jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig != null ? jobExecutionsRetryConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRetryConfig(JobExecutionsRetryConfig jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig;
            return this;
        }

        public final Map<String, String> getDocumentParameters() {
            if (this.documentParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.documentParameters;
        }

        public final void setDocumentParameters(Map<String, String> documentParameters) {
            this.documentParameters = ParameterMapCopier.copy(documentParameters);
        }

        @Override
        public final Builder documentParameters(Map<String, String> documentParameters) {
            this.documentParameters = ParameterMapCopier.copy(documentParameters);
            return this;
        }

        public Job build() {
            return new Job(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Job> {
        public Builder jobArn(String var1);

        public Builder jobId(String var1);

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder forceCanceled(Boolean var1);

        public Builder reasonCode(String var1);

        public Builder comment(String var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder description(String var1);

        public Builder presignedUrlConfig(PresignedUrlConfig var1);

        default public Builder presignedUrlConfig(Consumer<PresignedUrlConfig.Builder> presignedUrlConfig) {
            return this.presignedUrlConfig((PresignedUrlConfig)((PresignedUrlConfig.Builder)PresignedUrlConfig.builder().applyMutation(presignedUrlConfig)).build());
        }

        public Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig var1);

        default public Builder jobExecutionsRolloutConfig(Consumer<JobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return this.jobExecutionsRolloutConfig((JobExecutionsRolloutConfig)((JobExecutionsRolloutConfig.Builder)JobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)).build());
        }

        public Builder abortConfig(AbortConfig var1);

        default public Builder abortConfig(Consumer<AbortConfig.Builder> abortConfig) {
            return this.abortConfig((AbortConfig)((AbortConfig.Builder)AbortConfig.builder().applyMutation(abortConfig)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder jobProcessDetails(JobProcessDetails var1);

        default public Builder jobProcessDetails(Consumer<JobProcessDetails.Builder> jobProcessDetails) {
            return this.jobProcessDetails((JobProcessDetails)((JobProcessDetails.Builder)JobProcessDetails.builder().applyMutation(jobProcessDetails)).build());
        }

        public Builder timeoutConfig(TimeoutConfig var1);

        default public Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return this.timeoutConfig((TimeoutConfig)((TimeoutConfig.Builder)TimeoutConfig.builder().applyMutation(timeoutConfig)).build());
        }

        public Builder namespaceId(String var1);

        public Builder jobTemplateArn(String var1);

        public Builder jobExecutionsRetryConfig(JobExecutionsRetryConfig var1);

        default public Builder jobExecutionsRetryConfig(Consumer<JobExecutionsRetryConfig.Builder> jobExecutionsRetryConfig) {
            return this.jobExecutionsRetryConfig((JobExecutionsRetryConfig)((JobExecutionsRetryConfig.Builder)JobExecutionsRetryConfig.builder().applyMutation(jobExecutionsRetryConfig)).build());
        }

        public Builder documentParameters(Map<String, String> var1);
    }
}

