/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.DocumentParameter;
import software.amazon.awssdk.services.iot.model.DocumentParametersCopier;
import software.amazon.awssdk.services.iot.model.EnvironmentsCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeManagedJobTemplateResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeManagedJobTemplateResponse> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(DescribeManagedJobTemplateResponse.getter(DescribeManagedJobTemplateResponse::templateName)).setter(DescribeManagedJobTemplateResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateArn").getter(DescribeManagedJobTemplateResponse.getter(DescribeManagedJobTemplateResponse::templateArn)).setter(DescribeManagedJobTemplateResponse.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeManagedJobTemplateResponse.getter(DescribeManagedJobTemplateResponse::description)).setter(DescribeManagedJobTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateVersion").getter(DescribeManagedJobTemplateResponse.getter(DescribeManagedJobTemplateResponse::templateVersion)).setter(DescribeManagedJobTemplateResponse.setter(Builder::templateVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateVersion").build()}).build();
    private static final SdkField<List<String>> ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environments").getter(DescribeManagedJobTemplateResponse.getter(DescribeManagedJobTemplateResponse::environments)).setter(DescribeManagedJobTemplateResponse.setter(Builder::environments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentParameter>> DOCUMENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documentParameters").getter(DescribeManagedJobTemplateResponse.getter(DescribeManagedJobTemplateResponse::documentParameters)).setter(DescribeManagedJobTemplateResponse.setter(Builder::documentParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("document").getter(DescribeManagedJobTemplateResponse.getter(DescribeManagedJobTemplateResponse::document)).setter(DescribeManagedJobTemplateResponse.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_ARN_FIELD, DESCRIPTION_FIELD, TEMPLATE_VERSION_FIELD, ENVIRONMENTS_FIELD, DOCUMENT_PARAMETERS_FIELD, DOCUMENT_FIELD));
    private final String templateName;
    private final String templateArn;
    private final String description;
    private final String templateVersion;
    private final List<String> environments;
    private final List<DocumentParameter> documentParameters;
    private final String document;

    private DescribeManagedJobTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateArn = builder.templateArn;
        this.description = builder.description;
        this.templateVersion = builder.templateVersion;
        this.environments = builder.environments;
        this.documentParameters = builder.documentParameters;
        this.document = builder.document;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String description() {
        return this.description;
    }

    public final String templateVersion() {
        return this.templateVersion;
    }

    public final boolean hasEnvironments() {
        return this.environments != null && !(this.environments instanceof SdkAutoConstructList);
    }

    public final List<String> environments() {
        return this.environments;
    }

    public final boolean hasDocumentParameters() {
        return this.documentParameters != null && !(this.documentParameters instanceof SdkAutoConstructList);
    }

    public final List<DocumentParameter> documentParameters() {
        return this.documentParameters;
    }

    public final String document() {
        return this.document;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironments() ? this.environments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentParameters() ? this.documentParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedJobTemplateResponse)) {
            return false;
        }
        DescribeManagedJobTemplateResponse other = (DescribeManagedJobTemplateResponse)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateVersion(), other.templateVersion()) && this.hasEnvironments() == other.hasEnvironments() && Objects.equals(this.environments(), other.environments()) && this.hasDocumentParameters() == other.hasDocumentParameters() && Objects.equals(this.documentParameters(), other.documentParameters()) && Objects.equals(this.document(), other.document());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeManagedJobTemplateResponse").add("TemplateName", (Object)this.templateName()).add("TemplateArn", (Object)this.templateArn()).add("Description", (Object)this.description()).add("TemplateVersion", (Object)this.templateVersion()).add("Environments", this.hasEnvironments() ? this.environments() : null).add("DocumentParameters", this.hasDocumentParameters() ? this.documentParameters() : null).add("Document", (Object)this.document()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "templateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "templateVersion": {
                return Optional.ofNullable(clazz.cast(this.templateVersion()));
            }
            case "environments": {
                return Optional.ofNullable(clazz.cast(this.environments()));
            }
            case "documentParameters": {
                return Optional.ofNullable(clazz.cast(this.documentParameters()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedJobTemplateResponse, T> g) {
        return obj -> g.apply((DescribeManagedJobTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String templateName;
        private String templateArn;
        private String description;
        private String templateVersion;
        private List<String> environments = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentParameter> documentParameters = DefaultSdkAutoConstructList.getInstance();
        private String document;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedJobTemplateResponse model) {
            super(model);
            this.templateName(model.templateName);
            this.templateArn(model.templateArn);
            this.description(model.description);
            this.templateVersion(model.templateVersion);
            this.environments(model.environments);
            this.documentParameters(model.documentParameters);
            this.document(model.document);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        @Transient
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateVersion() {
            return this.templateVersion;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Override
        @Transient
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public final Collection<String> getEnvironments() {
            if (this.environments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.environments;
        }

        public final void setEnvironments(Collection<String> environments) {
            this.environments = EnvironmentsCopier.copy(environments);
        }

        @Override
        @Transient
        public final Builder environments(Collection<String> environments) {
            this.environments = EnvironmentsCopier.copy(environments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environments(String ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        public final List<DocumentParameter.Builder> getDocumentParameters() {
            List<DocumentParameter.Builder> result = DocumentParametersCopier.copyToBuilder(this.documentParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentParameters(Collection<DocumentParameter.BuilderImpl> documentParameters) {
            this.documentParameters = DocumentParametersCopier.copyFromBuilder(documentParameters);
        }

        @Override
        @Transient
        public final Builder documentParameters(Collection<DocumentParameter> documentParameters) {
            this.documentParameters = DocumentParametersCopier.copy(documentParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder documentParameters(DocumentParameter ... documentParameters) {
            this.documentParameters(Arrays.asList(documentParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder documentParameters(Consumer<DocumentParameter.Builder> ... documentParameters) {
            this.documentParameters(Stream.of(documentParameters).map(c -> (DocumentParameter)((DocumentParameter.Builder)DocumentParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDocument() {
            return this.document;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        @Transient
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        @Override
        public DescribeManagedJobTemplateResponse build() {
            return new DescribeManagedJobTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeManagedJobTemplateResponse> {
        public Builder templateName(String var1);

        public Builder templateArn(String var1);

        public Builder description(String var1);

        public Builder templateVersion(String var1);

        public Builder environments(Collection<String> var1);

        public Builder environments(String ... var1);

        public Builder documentParameters(Collection<DocumentParameter> var1);

        public Builder documentParameters(DocumentParameter ... var1);

        public Builder documentParameters(Consumer<DocumentParameter.Builder> ... var1);

        public Builder document(String var1);
    }
}

