/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse;
import software.amazon.awssdk.services.iot.model.OTAUpdateSummary;

public class ListOTAUpdatesPublisher
implements SdkPublisher<ListOtaUpdatesResponse> {
    private final IotAsyncClient client;
    private final ListOtaUpdatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOTAUpdatesPublisher(IotAsyncClient client, ListOtaUpdatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOTAUpdatesPublisher(IotAsyncClient client, ListOtaUpdatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOtaUpdatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOtaUpdatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OTAUpdateSummary> otaUpdates() {
        Function<ListOtaUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.otaUpdates() != null) {
                return response.otaUpdates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOtaUpdatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOtaUpdatesResponseFetcher
    implements AsyncPageFetcher<ListOtaUpdatesResponse> {
        private ListOtaUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(ListOtaUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOtaUpdatesResponse> nextPage(ListOtaUpdatesResponse previousPage) {
            if (previousPage == null) {
                return ListOTAUpdatesPublisher.this.client.listOTAUpdates(ListOTAUpdatesPublisher.this.firstRequest);
            }
            return ListOTAUpdatesPublisher.this.client.listOTAUpdates((ListOtaUpdatesRequest)((Object)ListOTAUpdatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

