/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.JobExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecutionSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobExecutionSummary.getter(JobExecutionSummary::statusAsString)).setter(JobExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> QUEUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("queuedAt").getter(JobExecutionSummary.getter(JobExecutionSummary::queuedAt)).setter(JobExecutionSummary.setter(Builder::queuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(JobExecutionSummary.getter(JobExecutionSummary::startedAt)).setter(JobExecutionSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(JobExecutionSummary.getter(JobExecutionSummary::lastUpdatedAt)).setter(JobExecutionSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionNumber").getter(JobExecutionSummary.getter(JobExecutionSummary::executionNumber)).setter(JobExecutionSummary.setter(Builder::executionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, QUEUED_AT_FIELD, STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, EXECUTION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant queuedAt;
    private final Instant startedAt;
    private final Instant lastUpdatedAt;
    private final Long executionNumber;

    private JobExecutionSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.executionNumber = builder.executionNumber;
    }

    public final JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant queuedAt() {
        return this.queuedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Long executionNumber() {
        return this.executionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummary)) {
            return false;
        }
        JobExecutionSummary other = (JobExecutionSummary)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.queuedAt(), other.queuedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.executionNumber(), other.executionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"JobExecutionSummary").add("Status", (Object)this.statusAsString()).add("QueuedAt", (Object)this.queuedAt()).add("StartedAt", (Object)this.startedAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ExecutionNumber", (Object)this.executionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "queuedAt": {
                return Optional.ofNullable(clazz.cast(this.queuedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "executionNumber": {
                return Optional.ofNullable(clazz.cast(this.executionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSummary, T> g) {
        return obj -> g.apply((JobExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant queuedAt;
        private Instant startedAt;
        private Instant lastUpdatedAt;
        private Long executionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummary model) {
            this.status(model.status);
            this.queuedAt(model.queuedAt);
            this.startedAt(model.startedAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.executionNumber(model.executionNumber);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getQueuedAt() {
            return this.queuedAt;
        }

        @Override
        public final Builder queuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final void setQueuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getExecutionNumber() {
            return this.executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        public JobExecutionSummary build() {
            return new JobExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecutionSummary> {
        public Builder status(String var1);

        public Builder status(JobExecutionStatus var1);

        public Builder queuedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder executionNumber(Long var1);
    }
}

