/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.OTAUpdateSummary;
import software.amazon.awssdk.services.iot.model.OTAUpdatesSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOtaUpdatesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListOtaUpdatesResponse> {
    private static final SdkField<List<OTAUpdateSummary>> OTA_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("otaUpdates").getter(ListOtaUpdatesResponse.getter(ListOtaUpdatesResponse::otaUpdates)).setter(ListOtaUpdatesResponse.setter(Builder::otaUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OTAUpdateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOtaUpdatesResponse.getter(ListOtaUpdatesResponse::nextToken)).setter(ListOtaUpdatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATES_FIELD, NEXT_TOKEN_FIELD));
    private final List<OTAUpdateSummary> otaUpdates;
    private final String nextToken;

    private ListOtaUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.otaUpdates = builder.otaUpdates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOtaUpdates() {
        return this.otaUpdates != null && !(this.otaUpdates instanceof SdkAutoConstructList);
    }

    public final List<OTAUpdateSummary> otaUpdates() {
        return this.otaUpdates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtaUpdates() ? this.otaUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOtaUpdatesResponse)) {
            return false;
        }
        ListOtaUpdatesResponse other = (ListOtaUpdatesResponse)((Object)obj);
        return this.hasOtaUpdates() == other.hasOtaUpdates() && Objects.equals(this.otaUpdates(), other.otaUpdates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOtaUpdatesResponse").add("OtaUpdates", this.hasOtaUpdates() ? this.otaUpdates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "otaUpdates": {
                return Optional.ofNullable(clazz.cast(this.otaUpdates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOtaUpdatesResponse, T> g) {
        return obj -> g.apply((ListOtaUpdatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<OTAUpdateSummary> otaUpdates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOtaUpdatesResponse model) {
            super(model);
            this.otaUpdates(model.otaUpdates);
            this.nextToken(model.nextToken);
        }

        public final List<OTAUpdateSummary.Builder> getOtaUpdates() {
            List<OTAUpdateSummary.Builder> result = OTAUpdatesSummaryCopier.copyToBuilder(this.otaUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder otaUpdates(Collection<OTAUpdateSummary> otaUpdates) {
            this.otaUpdates = OTAUpdatesSummaryCopier.copy(otaUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdates(OTAUpdateSummary ... otaUpdates) {
            this.otaUpdates(Arrays.asList(otaUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdates(Consumer<OTAUpdateSummary.Builder> ... otaUpdates) {
            this.otaUpdates(Stream.of(otaUpdates).map(c -> (OTAUpdateSummary)((OTAUpdateSummary.Builder)OTAUpdateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOtaUpdates(Collection<OTAUpdateSummary.BuilderImpl> otaUpdates) {
            this.otaUpdates = OTAUpdatesSummaryCopier.copyFromBuilder(otaUpdates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOtaUpdatesResponse build() {
            return new ListOtaUpdatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOtaUpdatesResponse> {
        public Builder otaUpdates(Collection<OTAUpdateSummary> var1);

        public Builder otaUpdates(OTAUpdateSummary ... var1);

        public Builder otaUpdates(Consumer<OTAUpdateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

