/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThing;
import software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobExecutionsForThingResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListJobExecutionsForThingResponse> {
    private static final SdkField<List<JobExecutionSummaryForThing>> EXECUTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionSummaries").getter(ListJobExecutionsForThingResponse.getter(ListJobExecutionsForThingResponse::executionSummaries)).setter(ListJobExecutionsForThingResponse.setter(Builder::executionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobExecutionSummaryForThing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobExecutionsForThingResponse.getter(ListJobExecutionsForThingResponse::nextToken)).setter(ListJobExecutionsForThingResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<JobExecutionSummaryForThing> executionSummaries;
    private final String nextToken;

    private ListJobExecutionsForThingResponse(BuilderImpl builder) {
        super(builder);
        this.executionSummaries = builder.executionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExecutionSummaries() {
        return this.executionSummaries != null && !(this.executionSummaries instanceof SdkAutoConstructList);
    }

    public final List<JobExecutionSummaryForThing> executionSummaries() {
        return this.executionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionSummaries() ? this.executionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobExecutionsForThingResponse)) {
            return false;
        }
        ListJobExecutionsForThingResponse other = (ListJobExecutionsForThingResponse)((Object)obj);
        return this.hasExecutionSummaries() == other.hasExecutionSummaries() && Objects.equals(this.executionSummaries(), other.executionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobExecutionsForThingResponse").add("ExecutionSummaries", this.hasExecutionSummaries() ? this.executionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionSummaries": {
                return Optional.ofNullable(clazz.cast(this.executionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobExecutionsForThingResponse, T> g) {
        return obj -> g.apply((ListJobExecutionsForThingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<JobExecutionSummaryForThing> executionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobExecutionsForThingResponse model) {
            super(model);
            this.executionSummaries(model.executionSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobExecutionSummaryForThing.Builder> getExecutionSummaries() {
            if (this.executionSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.executionSummaries != null ? (Collection)this.executionSummaries.stream().map(JobExecutionSummaryForThing::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder executionSummaries(Collection<JobExecutionSummaryForThing> executionSummaries) {
            this.executionSummaries = JobExecutionSummaryForThingListCopier.copy(executionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(JobExecutionSummaryForThing ... executionSummaries) {
            this.executionSummaries(Arrays.asList(executionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(Consumer<JobExecutionSummaryForThing.Builder> ... executionSummaries) {
            this.executionSummaries(Stream.of(executionSummaries).map(c -> (JobExecutionSummaryForThing)((JobExecutionSummaryForThing.Builder)JobExecutionSummaryForThing.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExecutionSummaries(Collection<JobExecutionSummaryForThing.BuilderImpl> executionSummaries) {
            this.executionSummaries = JobExecutionSummaryForThingListCopier.copyFromBuilder(executionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobExecutionsForThingResponse build() {
            return new ListJobExecutionsForThingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobExecutionsForThingResponse> {
        public Builder executionSummaries(Collection<JobExecutionSummaryForThing> var1);

        public Builder executionSummaries(JobExecutionSummaryForThing ... var1);

        public Builder executionSummaries(Consumer<JobExecutionSummaryForThing.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

