/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.MetricNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomMetricsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListCustomMetricsResponse> {
    private static final SdkField<List<String>> METRIC_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricNames").getter(ListCustomMetricsResponse.getter(ListCustomMetricsResponse::metricNames)).setter(ListCustomMetricsResponse.setter(Builder::metricNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCustomMetricsResponse.getter(ListCustomMetricsResponse::nextToken)).setter(ListCustomMetricsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> metricNames;
    private final String nextToken;

    private ListCustomMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.metricNames = builder.metricNames;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetricNames() {
        return this.metricNames != null && !(this.metricNames instanceof SdkAutoConstructList);
    }

    public final List<String> metricNames() {
        return this.metricNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricNames() ? this.metricNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomMetricsResponse)) {
            return false;
        }
        ListCustomMetricsResponse other = (ListCustomMetricsResponse)((Object)obj);
        return this.hasMetricNames() == other.hasMetricNames() && Objects.equals(this.metricNames(), other.metricNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomMetricsResponse").add("MetricNames", this.hasMetricNames() ? this.metricNames() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricNames": {
                return Optional.ofNullable(clazz.cast(this.metricNames()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomMetricsResponse, T> g) {
        return obj -> g.apply((ListCustomMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> metricNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomMetricsResponse model) {
            super(model);
            this.metricNames(model.metricNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getMetricNames() {
            if (this.metricNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricNames;
        }

        @Override
        public final Builder metricNames(Collection<String> metricNames) {
            this.metricNames = MetricNamesCopier.copy(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNames(String ... metricNames) {
            this.metricNames(Arrays.asList(metricNames));
            return this;
        }

        public final void setMetricNames(Collection<String> metricNames) {
            this.metricNames = MetricNamesCopier.copy(metricNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCustomMetricsResponse build() {
            return new ListCustomMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomMetricsResponse> {
        public Builder metricNames(Collection<String> var1);

        public Builder metricNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

