/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamFile> {
    private static final SdkField<Integer> FILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("fileId").getter(StreamFile.getter(StreamFile::fileId)).setter(StreamFile.setter(Builder::fileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()}).build();
    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(StreamFile.getter(StreamFile::s3Location)).setter(StreamFile.setter(Builder::s3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ID_FIELD, S3_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fileId;
    private final S3Location s3Location;

    private StreamFile(BuilderImpl builder) {
        this.fileId = builder.fileId;
        this.s3Location = builder.s3Location;
    }

    public final Integer fileId() {
        return this.fileId;
    }

    public final S3Location s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamFile)) {
            return false;
        }
        StreamFile other = (StreamFile)obj;
        return Objects.equals(this.fileId(), other.fileId()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public final String toString() {
        return ToString.builder((String)"StreamFile").add("FileId", (Object)this.fileId()).add("S3Location", (Object)this.s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileId": {
                return Optional.ofNullable(clazz.cast(this.fileId()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamFile, T> g) {
        return obj -> g.apply((StreamFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fileId;
        private S3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamFile model) {
            this.fileId(model.fileId);
            this.s3Location(model.s3Location);
        }

        public final Integer getFileId() {
            return this.fileId;
        }

        @Override
        public final Builder fileId(Integer fileId) {
            this.fileId = fileId;
            return this;
        }

        public final void setFileId(Integer fileId) {
            this.fileId = fileId;
        }

        public final S3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public StreamFile build() {
            return new StreamFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamFile> {
        public Builder fileId(Integer var1);

        public Builder s3Location(S3Location var1);

        default public Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return this.s3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3Location)).build());
        }
    }
}

