/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata;
import software.amazon.awssdk.services.iot.model.ScheduledAuditMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScheduledAuditsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListScheduledAuditsResponse> {
    private static final SdkField<List<ScheduledAuditMetadata>> SCHEDULED_AUDITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scheduledAudits").getter(ListScheduledAuditsResponse.getter(ListScheduledAuditsResponse::scheduledAudits)).setter(ListScheduledAuditsResponse.setter(Builder::scheduledAudits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledAudits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledAuditMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListScheduledAuditsResponse.getter(ListScheduledAuditsResponse::nextToken)).setter(ListScheduledAuditsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_AUDITS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScheduledAuditMetadata> scheduledAudits;
    private final String nextToken;

    private ListScheduledAuditsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledAudits = builder.scheduledAudits;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScheduledAudits() {
        return this.scheduledAudits != null && !(this.scheduledAudits instanceof SdkAutoConstructList);
    }

    public final List<ScheduledAuditMetadata> scheduledAudits() {
        return this.scheduledAudits;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledAudits() ? this.scheduledAudits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduledAuditsResponse)) {
            return false;
        }
        ListScheduledAuditsResponse other = (ListScheduledAuditsResponse)((Object)obj);
        return this.hasScheduledAudits() == other.hasScheduledAudits() && Objects.equals(this.scheduledAudits(), other.scheduledAudits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScheduledAuditsResponse").add("ScheduledAudits", this.hasScheduledAudits() ? this.scheduledAudits() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scheduledAudits": {
                return Optional.ofNullable(clazz.cast(this.scheduledAudits()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScheduledAuditsResponse, T> g) {
        return obj -> g.apply((ListScheduledAuditsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ScheduledAuditMetadata> scheduledAudits = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduledAuditsResponse model) {
            super(model);
            this.scheduledAudits(model.scheduledAudits);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScheduledAuditMetadata.Builder> getScheduledAudits() {
            if (this.scheduledAudits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scheduledAudits != null ? (Collection)this.scheduledAudits.stream().map(ScheduledAuditMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledAudits(Collection<ScheduledAuditMetadata> scheduledAudits) {
            this.scheduledAudits = ScheduledAuditMetadataListCopier.copy(scheduledAudits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledAudits(ScheduledAuditMetadata ... scheduledAudits) {
            this.scheduledAudits(Arrays.asList(scheduledAudits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledAudits(Consumer<ScheduledAuditMetadata.Builder> ... scheduledAudits) {
            this.scheduledAudits(Stream.of(scheduledAudits).map(c -> (ScheduledAuditMetadata)((ScheduledAuditMetadata.Builder)ScheduledAuditMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledAudits(Collection<ScheduledAuditMetadata.BuilderImpl> scheduledAudits) {
            this.scheduledAudits = ScheduledAuditMetadataListCopier.copyFromBuilder(scheduledAudits);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListScheduledAuditsResponse build() {
            return new ListScheduledAuditsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScheduledAuditsResponse> {
        public Builder scheduledAudits(Collection<ScheduledAuditMetadata> var1);

        public Builder scheduledAudits(ScheduledAuditMetadata ... var1);

        public Builder scheduledAudits(Consumer<ScheduledAuditMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

