/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisioningTemplateVersionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateProvisioningTemplateVersionResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateArn").getter(CreateProvisioningTemplateVersionResponse.getter(CreateProvisioningTemplateVersionResponse::templateArn)).setter(CreateProvisioningTemplateVersionResponse.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(CreateProvisioningTemplateVersionResponse.getter(CreateProvisioningTemplateVersionResponse::templateName)).setter(CreateProvisioningTemplateVersionResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final SdkField<Integer> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("versionId").getter(CreateProvisioningTemplateVersionResponse.getter(CreateProvisioningTemplateVersionResponse::versionId)).setter(CreateProvisioningTemplateVersionResponse.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDefaultVersion").getter(CreateProvisioningTemplateVersionResponse.getter(CreateProvisioningTemplateVersionResponse::isDefaultVersion)).setter(CreateProvisioningTemplateVersionResponse.setter(Builder::isDefaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefaultVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD, TEMPLATE_NAME_FIELD, VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD));
    private final String templateArn;
    private final String templateName;
    private final Integer versionId;
    private final Boolean isDefaultVersion;

    private CreateProvisioningTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final Integer versionId() {
        return this.versionId;
    }

    public final Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningTemplateVersionResponse)) {
            return false;
        }
        CreateProvisioningTemplateVersionResponse other = (CreateProvisioningTemplateVersionResponse)((Object)obj);
        return Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProvisioningTemplateVersionResponse").add("TemplateArn", (Object)this.templateArn()).add("TemplateName", (Object)this.templateName()).add("VersionId", (Object)this.versionId()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "versionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "isDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningTemplateVersionResponse, T> g) {
        return obj -> g.apply((CreateProvisioningTemplateVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String templateArn;
        private String templateName;
        private Integer versionId;
        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningTemplateVersionResponse model) {
            super(model);
            this.templateArn(model.templateArn);
            this.templateName(model.templateName);
            this.versionId(model.versionId);
            this.isDefaultVersion(model.isDefaultVersion);
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final Integer getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(Integer versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public CreateProvisioningTemplateVersionResponse build() {
            return new CreateProvisioningTemplateVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisioningTemplateVersionResponse> {
        public Builder templateArn(String var1);

        public Builder templateName(String var1);

        public Builder versionId(Integer var1);

        public Builder isDefaultVersion(Boolean var1);
    }
}

