/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AttributesCopier;
import software.amazon.awssdk.services.iot.model.ThingConnectivity;
import software.amazon.awssdk.services.iot.model.ThingGroupNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingDocument> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(ThingDocument.getter(ThingDocument::thingName)).setter(ThingDocument.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> THING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingId").getter(ThingDocument.getter(ThingDocument::thingId)).setter(ThingDocument.setter(Builder::thingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingId").build()}).build();
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingTypeName").getter(ThingDocument.getter(ThingDocument::thingTypeName)).setter(ThingDocument.setter(Builder::thingTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()}).build();
    private static final SdkField<List<String>> THING_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thingGroupNames").getter(ThingDocument.getter(ThingDocument::thingGroupNames)).setter(ThingDocument.setter(Builder::thingGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(ThingDocument.getter(ThingDocument::attributes)).setter(ThingDocument.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SHADOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shadow").getter(ThingDocument.getter(ThingDocument::shadow)).setter(ThingDocument.setter(Builder::shadow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadow").build()}).build();
    private static final SdkField<ThingConnectivity> CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectivity").getter(ThingDocument.getter(ThingDocument::connectivity)).setter(ThingDocument.setter(Builder::connectivity)).constructor(ThingConnectivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, THING_ID_FIELD, THING_TYPE_NAME_FIELD, THING_GROUP_NAMES_FIELD, ATTRIBUTES_FIELD, SHADOW_FIELD, CONNECTIVITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String thingName;
    private final String thingId;
    private final String thingTypeName;
    private final List<String> thingGroupNames;
    private final Map<String, String> attributes;
    private final String shadow;
    private final ThingConnectivity connectivity;

    private ThingDocument(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingId = builder.thingId;
        this.thingTypeName = builder.thingTypeName;
        this.thingGroupNames = builder.thingGroupNames;
        this.attributes = builder.attributes;
        this.shadow = builder.shadow;
        this.connectivity = builder.connectivity;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final String thingId() {
        return this.thingId;
    }

    public final String thingTypeName() {
        return this.thingTypeName;
    }

    public final boolean hasThingGroupNames() {
        return this.thingGroupNames != null && !(this.thingGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> thingGroupNames() {
        return this.thingGroupNames;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String shadow() {
        return this.shadow;
    }

    public final ThingConnectivity connectivity() {
        return this.connectivity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThingGroupNames() ? this.thingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.shadow());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingDocument)) {
            return false;
        }
        ThingDocument other = (ThingDocument)obj;
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingId(), other.thingId()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && this.hasThingGroupNames() == other.hasThingGroupNames() && Objects.equals(this.thingGroupNames(), other.thingGroupNames()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.shadow(), other.shadow()) && Objects.equals(this.connectivity(), other.connectivity());
    }

    public final String toString() {
        return ToString.builder((String)"ThingDocument").add("ThingName", (Object)this.thingName()).add("ThingId", (Object)this.thingId()).add("ThingTypeName", (Object)this.thingTypeName()).add("ThingGroupNames", this.hasThingGroupNames() ? this.thingGroupNames() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Shadow", (Object)this.shadow()).add("Connectivity", (Object)this.connectivity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingId": {
                return Optional.ofNullable(clazz.cast(this.thingId()));
            }
            case "thingTypeName": {
                return Optional.ofNullable(clazz.cast(this.thingTypeName()));
            }
            case "thingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.thingGroupNames()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "shadow": {
                return Optional.ofNullable(clazz.cast(this.shadow()));
            }
            case "connectivity": {
                return Optional.ofNullable(clazz.cast(this.connectivity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingDocument, T> g) {
        return obj -> g.apply((ThingDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingName;
        private String thingId;
        private String thingTypeName;
        private List<String> thingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String shadow;
        private ThingConnectivity connectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingDocument model) {
            this.thingName(model.thingName);
            this.thingId(model.thingId);
            this.thingTypeName(model.thingTypeName);
            this.thingGroupNames(model.thingGroupNames);
            this.attributes(model.attributes);
            this.shadow(model.shadow);
            this.connectivity(model.connectivity);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingId() {
            return this.thingId;
        }

        @Override
        public final Builder thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public final void setThingId(String thingId) {
            this.thingId = thingId;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Collection<String> getThingGroupNames() {
            if (this.thingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.thingGroupNames;
        }

        @Override
        public final Builder thingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupNames(String ... thingGroupNames) {
            this.thingGroupNames(Arrays.asList(thingGroupNames));
            return this;
        }

        public final void setThingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final String getShadow() {
            return this.shadow;
        }

        @Override
        public final Builder shadow(String shadow) {
            this.shadow = shadow;
            return this;
        }

        public final void setShadow(String shadow) {
            this.shadow = shadow;
        }

        public final ThingConnectivity.Builder getConnectivity() {
            return this.connectivity != null ? this.connectivity.toBuilder() : null;
        }

        @Override
        public final Builder connectivity(ThingConnectivity connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        public final void setConnectivity(ThingConnectivity.BuilderImpl connectivity) {
            this.connectivity = connectivity != null ? connectivity.build() : null;
        }

        public ThingDocument build() {
            return new ThingDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingDocument> {
        public Builder thingName(String var1);

        public Builder thingId(String var1);

        public Builder thingTypeName(String var1);

        public Builder thingGroupNames(Collection<String> var1);

        public Builder thingGroupNames(String ... var1);

        public Builder attributes(Map<String, String> var1);

        public Builder shadow(String var1);

        public Builder connectivity(ThingConnectivity var1);

        default public Builder connectivity(Consumer<ThingConnectivity.Builder> connectivity) {
            return this.connectivity((ThingConnectivity)((ThingConnectivity.Builder)ThingConnectivity.builder().applyMutation(connectivity)).build());
        }
    }
}

