/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ThingGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThingGroupsForThingRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateThingGroupsForThingRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(UpdateThingGroupsForThingRequest.getter(UpdateThingGroupsForThingRequest::thingName)).setter(UpdateThingGroupsForThingRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<List<String>> THING_GROUPS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thingGroupsToAdd").getter(UpdateThingGroupsForThingRequest.getter(UpdateThingGroupsForThingRequest::thingGroupsToAdd)).setter(UpdateThingGroupsForThingRequest.setter(Builder::thingGroupsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> THING_GROUPS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thingGroupsToRemove").getter(UpdateThingGroupsForThingRequest.getter(UpdateThingGroupsForThingRequest::thingGroupsToRemove)).setter(UpdateThingGroupsForThingRequest.setter(Builder::thingGroupsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> OVERRIDE_DYNAMIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("overrideDynamicGroups").getter(UpdateThingGroupsForThingRequest.getter(UpdateThingGroupsForThingRequest::overrideDynamicGroups)).setter(UpdateThingGroupsForThingRequest.setter(Builder::overrideDynamicGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideDynamicGroups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, THING_GROUPS_TO_ADD_FIELD, THING_GROUPS_TO_REMOVE_FIELD, OVERRIDE_DYNAMIC_GROUPS_FIELD));
    private final String thingName;
    private final List<String> thingGroupsToAdd;
    private final List<String> thingGroupsToRemove;
    private final Boolean overrideDynamicGroups;

    private UpdateThingGroupsForThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingGroupsToAdd = builder.thingGroupsToAdd;
        this.thingGroupsToRemove = builder.thingGroupsToRemove;
        this.overrideDynamicGroups = builder.overrideDynamicGroups;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final boolean hasThingGroupsToAdd() {
        return this.thingGroupsToAdd != null && !(this.thingGroupsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> thingGroupsToAdd() {
        return this.thingGroupsToAdd;
    }

    public final boolean hasThingGroupsToRemove() {
        return this.thingGroupsToRemove != null && !(this.thingGroupsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> thingGroupsToRemove() {
        return this.thingGroupsToRemove;
    }

    public final Boolean overrideDynamicGroups() {
        return this.overrideDynamicGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThingGroupsToAdd() ? this.thingGroupsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThingGroupsToRemove() ? this.thingGroupsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideDynamicGroups());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingGroupsForThingRequest)) {
            return false;
        }
        UpdateThingGroupsForThingRequest other = (UpdateThingGroupsForThingRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && this.hasThingGroupsToAdd() == other.hasThingGroupsToAdd() && Objects.equals(this.thingGroupsToAdd(), other.thingGroupsToAdd()) && this.hasThingGroupsToRemove() == other.hasThingGroupsToRemove() && Objects.equals(this.thingGroupsToRemove(), other.thingGroupsToRemove()) && Objects.equals(this.overrideDynamicGroups(), other.overrideDynamicGroups());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateThingGroupsForThingRequest").add("ThingName", (Object)this.thingName()).add("ThingGroupsToAdd", this.hasThingGroupsToAdd() ? this.thingGroupsToAdd() : null).add("ThingGroupsToRemove", this.hasThingGroupsToRemove() ? this.thingGroupsToRemove() : null).add("OverrideDynamicGroups", (Object)this.overrideDynamicGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingGroupsToAdd": {
                return Optional.ofNullable(clazz.cast(this.thingGroupsToAdd()));
            }
            case "thingGroupsToRemove": {
                return Optional.ofNullable(clazz.cast(this.thingGroupsToRemove()));
            }
            case "overrideDynamicGroups": {
                return Optional.ofNullable(clazz.cast(this.overrideDynamicGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThingGroupsForThingRequest, T> g) {
        return obj -> g.apply((UpdateThingGroupsForThingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private List<String> thingGroupsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> thingGroupsToRemove = DefaultSdkAutoConstructList.getInstance();
        private Boolean overrideDynamicGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingGroupsForThingRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.thingGroupsToAdd(model.thingGroupsToAdd);
            this.thingGroupsToRemove(model.thingGroupsToRemove);
            this.overrideDynamicGroups(model.overrideDynamicGroups);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Collection<String> getThingGroupsToAdd() {
            if (this.thingGroupsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.thingGroupsToAdd;
        }

        @Override
        public final Builder thingGroupsToAdd(Collection<String> thingGroupsToAdd) {
            this.thingGroupsToAdd = ThingGroupListCopier.copy(thingGroupsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupsToAdd(String ... thingGroupsToAdd) {
            this.thingGroupsToAdd(Arrays.asList(thingGroupsToAdd));
            return this;
        }

        public final void setThingGroupsToAdd(Collection<String> thingGroupsToAdd) {
            this.thingGroupsToAdd = ThingGroupListCopier.copy(thingGroupsToAdd);
        }

        public final Collection<String> getThingGroupsToRemove() {
            if (this.thingGroupsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.thingGroupsToRemove;
        }

        @Override
        public final Builder thingGroupsToRemove(Collection<String> thingGroupsToRemove) {
            this.thingGroupsToRemove = ThingGroupListCopier.copy(thingGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupsToRemove(String ... thingGroupsToRemove) {
            this.thingGroupsToRemove(Arrays.asList(thingGroupsToRemove));
            return this;
        }

        public final void setThingGroupsToRemove(Collection<String> thingGroupsToRemove) {
            this.thingGroupsToRemove = ThingGroupListCopier.copy(thingGroupsToRemove);
        }

        public final Boolean getOverrideDynamicGroups() {
            return this.overrideDynamicGroups;
        }

        @Override
        public final Builder overrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
            return this;
        }

        public final void setOverrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingGroupsForThingRequest build() {
            return new UpdateThingGroupsForThingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateThingGroupsForThingRequest> {
        public Builder thingName(String var1);

        public Builder thingGroupsToAdd(Collection<String> var1);

        public Builder thingGroupsToAdd(String ... var1);

        public Builder thingGroupsToRemove(Collection<String> var1);

        public Builder thingGroupsToRemove(String ... var1);

        public Builder overrideDynamicGroups(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

