/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMitigationActionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, UpdateMitigationActionResponse> {
    private static final SdkField<String> ACTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionArn").getter(UpdateMitigationActionResponse.getter(UpdateMitigationActionResponse::actionArn)).setter(UpdateMitigationActionResponse.setter(Builder::actionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionArn").build()}).build();
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(UpdateMitigationActionResponse.getter(UpdateMitigationActionResponse::actionId)).setter(UpdateMitigationActionResponse.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ARN_FIELD, ACTION_ID_FIELD));
    private final String actionArn;
    private final String actionId;

    private UpdateMitigationActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionArn = builder.actionArn;
        this.actionId = builder.actionId;
    }

    public String actionArn() {
        return this.actionArn;
    }

    public String actionId() {
        return this.actionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMitigationActionResponse)) {
            return false;
        }
        UpdateMitigationActionResponse other = (UpdateMitigationActionResponse)((Object)obj);
        return Objects.equals(this.actionArn(), other.actionArn()) && Objects.equals(this.actionId(), other.actionId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMitigationActionResponse").add("ActionArn", (Object)this.actionArn()).add("ActionId", (Object)this.actionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionArn": {
                return Optional.ofNullable(clazz.cast(this.actionArn()));
            }
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMitigationActionResponse, T> g) {
        return obj -> g.apply((UpdateMitigationActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String actionArn;
        private String actionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMitigationActionResponse model) {
            super(model);
            this.actionArn(model.actionArn);
            this.actionId(model.actionId);
        }

        public final String getActionArn() {
            return this.actionArn;
        }

        @Override
        public final Builder actionArn(String actionArn) {
            this.actionArn = actionArn;
            return this;
        }

        public final void setActionArn(String actionArn) {
            this.actionArn = actionArn;
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public UpdateMitigationActionResponse build() {
            return new UpdateMitigationActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMitigationActionResponse> {
        public Builder actionArn(String var1);

        public Builder actionId(String var1);
    }
}

