/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.PutAssetPropertyValueEntry;
import software.amazon.awssdk.services.iot.model.PutAssetPropertyValueEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotSiteWiseAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IotSiteWiseAction> {
    private static final SdkField<List<PutAssetPropertyValueEntry>> PUT_ASSET_PROPERTY_VALUE_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("putAssetPropertyValueEntries").getter(IotSiteWiseAction.getter(IotSiteWiseAction::putAssetPropertyValueEntries)).setter(IotSiteWiseAction.setter(Builder::putAssetPropertyValueEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("putAssetPropertyValueEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutAssetPropertyValueEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(IotSiteWiseAction.getter(IotSiteWiseAction::roleArn)).setter(IotSiteWiseAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUT_ASSET_PROPERTY_VALUE_ENTRIES_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PutAssetPropertyValueEntry> putAssetPropertyValueEntries;
    private final String roleArn;

    private IotSiteWiseAction(BuilderImpl builder) {
        this.putAssetPropertyValueEntries = builder.putAssetPropertyValueEntries;
        this.roleArn = builder.roleArn;
    }

    public boolean hasPutAssetPropertyValueEntries() {
        return this.putAssetPropertyValueEntries != null && !(this.putAssetPropertyValueEntries instanceof SdkAutoConstructList);
    }

    public List<PutAssetPropertyValueEntry> putAssetPropertyValueEntries() {
        return this.putAssetPropertyValueEntries;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.putAssetPropertyValueEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotSiteWiseAction)) {
            return false;
        }
        IotSiteWiseAction other = (IotSiteWiseAction)obj;
        return Objects.equals(this.putAssetPropertyValueEntries(), other.putAssetPropertyValueEntries()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"IotSiteWiseAction").add("PutAssetPropertyValueEntries", this.putAssetPropertyValueEntries()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "putAssetPropertyValueEntries": {
                return Optional.ofNullable(clazz.cast(this.putAssetPropertyValueEntries()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotSiteWiseAction, T> g) {
        return obj -> g.apply((IotSiteWiseAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PutAssetPropertyValueEntry> putAssetPropertyValueEntries = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotSiteWiseAction model) {
            this.putAssetPropertyValueEntries(model.putAssetPropertyValueEntries);
            this.roleArn(model.roleArn);
        }

        public final Collection<PutAssetPropertyValueEntry.Builder> getPutAssetPropertyValueEntries() {
            return this.putAssetPropertyValueEntries != null ? (Collection)this.putAssetPropertyValueEntries.stream().map(PutAssetPropertyValueEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder putAssetPropertyValueEntries(Collection<PutAssetPropertyValueEntry> putAssetPropertyValueEntries) {
            this.putAssetPropertyValueEntries = PutAssetPropertyValueEntryListCopier.copy(putAssetPropertyValueEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder putAssetPropertyValueEntries(PutAssetPropertyValueEntry ... putAssetPropertyValueEntries) {
            this.putAssetPropertyValueEntries(Arrays.asList(putAssetPropertyValueEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder putAssetPropertyValueEntries(Consumer<PutAssetPropertyValueEntry.Builder> ... putAssetPropertyValueEntries) {
            this.putAssetPropertyValueEntries(Stream.of(putAssetPropertyValueEntries).map(c -> (PutAssetPropertyValueEntry)((PutAssetPropertyValueEntry.Builder)PutAssetPropertyValueEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPutAssetPropertyValueEntries(Collection<PutAssetPropertyValueEntry.BuilderImpl> putAssetPropertyValueEntries) {
            this.putAssetPropertyValueEntries = PutAssetPropertyValueEntryListCopier.copyFromBuilder(putAssetPropertyValueEntries);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public IotSiteWiseAction build() {
            return new IotSiteWiseAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IotSiteWiseAction> {
        public Builder putAssetPropertyValueEntries(Collection<PutAssetPropertyValueEntry> var1);

        public Builder putAssetPropertyValueEntries(PutAssetPropertyValueEntry ... var1);

        public Builder putAssetPropertyValueEntries(Consumer<PutAssetPropertyValueEntry.Builder> ... var1);

        public Builder roleArn(String var1);
    }
}

