/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.MitigationActionIdentifier;
import software.amazon.awssdk.services.iot.model.MitigationActionIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMitigationActionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListMitigationActionsResponse> {
    private static final SdkField<List<MitigationActionIdentifier>> ACTION_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionIdentifiers").getter(ListMitigationActionsResponse.getter(ListMitigationActionsResponse::actionIdentifiers)).setter(ListMitigationActionsResponse.setter(Builder::actionIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MitigationActionIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMitigationActionsResponse.getter(ListMitigationActionsResponse::nextToken)).setter(ListMitigationActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MitigationActionIdentifier> actionIdentifiers;
    private final String nextToken;

    private ListMitigationActionsResponse(BuilderImpl builder) {
        super(builder);
        this.actionIdentifiers = builder.actionIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasActionIdentifiers() {
        return this.actionIdentifiers != null && !(this.actionIdentifiers instanceof SdkAutoConstructList);
    }

    public List<MitigationActionIdentifier> actionIdentifiers() {
        return this.actionIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMitigationActionsResponse)) {
            return false;
        }
        ListMitigationActionsResponse other = (ListMitigationActionsResponse)((Object)obj);
        return Objects.equals(this.actionIdentifiers(), other.actionIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMitigationActionsResponse").add("ActionIdentifiers", this.actionIdentifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.actionIdentifiers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMitigationActionsResponse, T> g) {
        return obj -> g.apply((ListMitigationActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<MitigationActionIdentifier> actionIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMitigationActionsResponse model) {
            super(model);
            this.actionIdentifiers(model.actionIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<MitigationActionIdentifier.Builder> getActionIdentifiers() {
            return this.actionIdentifiers != null ? (Collection)this.actionIdentifiers.stream().map(MitigationActionIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionIdentifiers(Collection<MitigationActionIdentifier> actionIdentifiers) {
            this.actionIdentifiers = MitigationActionIdentifierListCopier.copy(actionIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionIdentifiers(MitigationActionIdentifier ... actionIdentifiers) {
            this.actionIdentifiers(Arrays.asList(actionIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionIdentifiers(Consumer<MitigationActionIdentifier.Builder> ... actionIdentifiers) {
            this.actionIdentifiers(Stream.of(actionIdentifiers).map(c -> (MitigationActionIdentifier)((MitigationActionIdentifier.Builder)MitigationActionIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActionIdentifiers(Collection<MitigationActionIdentifier.BuilderImpl> actionIdentifiers) {
            this.actionIdentifiers = MitigationActionIdentifierListCopier.copyFromBuilder(actionIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMitigationActionsResponse build() {
            return new ListMitigationActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMitigationActionsResponse> {
        public Builder actionIdentifiers(Collection<MitigationActionIdentifier> var1);

        public Builder actionIdentifiers(MitigationActionIdentifier ... var1);

        public Builder actionIdentifiers(Consumer<MitigationActionIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

