/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse;

public class ListCustomMetricsIterable
implements SdkIterable<ListCustomMetricsResponse> {
    private final IotClient client;
    private final ListCustomMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomMetricsIterable(IotClient client, ListCustomMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCustomMetricsResponseFetcher();
    }

    public Iterator<ListCustomMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> metricNames() {
        Function<ListCustomMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricNames() != null) {
                return response.metricNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomMetricsResponseFetcher
    implements SyncPageFetcher<ListCustomMetricsResponse> {
        private ListCustomMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomMetricsResponse nextPage(ListCustomMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomMetricsIterable.this.client.listCustomMetrics(ListCustomMetricsIterable.this.firstRequest);
            }
            return ListCustomMetricsIterable.this.client.listCustomMetrics((ListCustomMetricsRequest)((Object)ListCustomMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

