/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(KinesisAction.getter(KinesisAction::roleArn)).setter(KinesisAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamName").getter(KinesisAction.getter(KinesisAction::streamName)).setter(KinesisAction.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()}).build();
    private static final SdkField<String> PARTITION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partitionKey").getter(KinesisAction.getter(KinesisAction::partitionKey)).setter(KinesisAction.setter(Builder::partitionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, STREAM_NAME_FIELD, PARTITION_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String streamName;
    private final String partitionKey;

    private KinesisAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.streamName = builder.streamName;
        this.partitionKey = builder.partitionKey;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String streamName() {
        return this.streamName;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisAction)) {
            return false;
        }
        KinesisAction other = (KinesisAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.partitionKey(), other.partitionKey());
    }

    public String toString() {
        return ToString.builder((String)"KinesisAction").add("RoleArn", (Object)this.roleArn()).add("StreamName", (Object)this.streamName()).add("PartitionKey", (Object)this.partitionKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "streamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "partitionKey": {
                return Optional.ofNullable(clazz.cast(this.partitionKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisAction, T> g) {
        return obj -> g.apply((KinesisAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String streamName;
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisAction model) {
            this.roleArn(model.roleArn);
            this.streamName(model.streamName);
            this.partitionKey(model.partitionKey);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public KinesisAction build() {
            return new KinesisAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisAction> {
        public Builder roleArn(String var1);

        public Builder streamName(String var1);

        public Builder partitionKey(String var1);
    }
}

