/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuthorizerConfig;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ServerCertificateArnsCopier;
import software.amazon.awssdk.services.iot.model.ServiceType;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainConfigurationRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateDomainConfigurationRequest> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::domainConfigurationName)).setter(CreateDomainConfigurationRequest.setter(Builder::domainConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainConfigurationName").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::domainName)).setter(CreateDomainConfigurationRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<List<String>> SERVER_CERTIFICATE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::serverCertificateArns)).setter(CreateDomainConfigurationRequest.setter(Builder::serverCertificateArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VALIDATION_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::validationCertificateArn)).setter(CreateDomainConfigurationRequest.setter(Builder::validationCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationCertificateArn").build()}).build();
    private static final SdkField<AuthorizerConfig> AUTHORIZER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::authorizerConfig)).setter(CreateDomainConfigurationRequest.setter(Builder::authorizerConfig)).constructor(AuthorizerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfig").build()}).build();
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::serviceTypeAsString)).setter(CreateDomainConfigurationRequest.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::tags)).setter(CreateDomainConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_NAME_FIELD, SERVER_CERTIFICATE_ARNS_FIELD, VALIDATION_CERTIFICATE_ARN_FIELD, AUTHORIZER_CONFIG_FIELD, SERVICE_TYPE_FIELD, TAGS_FIELD));
    private final String domainConfigurationName;
    private final String domainName;
    private final List<String> serverCertificateArns;
    private final String validationCertificateArn;
    private final AuthorizerConfig authorizerConfig;
    private final String serviceType;
    private final List<Tag> tags;

    private CreateDomainConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainName = builder.domainName;
        this.serverCertificateArns = builder.serverCertificateArns;
        this.validationCertificateArn = builder.validationCertificateArn;
        this.authorizerConfig = builder.authorizerConfig;
        this.serviceType = builder.serviceType;
        this.tags = builder.tags;
    }

    public String domainConfigurationName() {
        return this.domainConfigurationName;
    }

    public String domainName() {
        return this.domainName;
    }

    public boolean hasServerCertificateArns() {
        return this.serverCertificateArns != null && !(this.serverCertificateArns instanceof SdkAutoConstructList);
    }

    public List<String> serverCertificateArns() {
        return this.serverCertificateArns;
    }

    public String validationCertificateArn() {
        return this.validationCertificateArn;
    }

    public AuthorizerConfig authorizerConfig() {
        return this.authorizerConfig;
    }

    public ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public String serviceTypeAsString() {
        return this.serviceType;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainConfigurationRequest)) {
            return false;
        }
        CreateDomainConfigurationRequest other = (CreateDomainConfigurationRequest)((Object)obj);
        return Objects.equals(this.domainConfigurationName(), other.domainConfigurationName()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.serverCertificateArns(), other.serverCertificateArns()) && Objects.equals(this.validationCertificateArn(), other.validationCertificateArn()) && Objects.equals(this.authorizerConfig(), other.authorizerConfig()) && Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDomainConfigurationRequest").add("DomainConfigurationName", (Object)this.domainConfigurationName()).add("DomainName", (Object)this.domainName()).add("ServerCertificateArns", this.serverCertificateArns()).add("ValidationCertificateArn", (Object)this.validationCertificateArn()).add("AuthorizerConfig", (Object)this.authorizerConfig()).add("ServiceType", (Object)this.serviceTypeAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationName()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "serverCertificateArns": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateArns()));
            }
            case "validationCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.validationCertificateArn()));
            }
            case "authorizerConfig": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfig()));
            }
            case "serviceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainConfigurationRequest, T> g) {
        return obj -> g.apply((CreateDomainConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String domainConfigurationName;
        private String domainName;
        private List<String> serverCertificateArns = DefaultSdkAutoConstructList.getInstance();
        private String validationCertificateArn;
        private AuthorizerConfig authorizerConfig;
        private String serviceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainConfigurationRequest model) {
            super(model);
            this.domainConfigurationName(model.domainConfigurationName);
            this.domainName(model.domainName);
            this.serverCertificateArns(model.serverCertificateArns);
            this.validationCertificateArn(model.validationCertificateArn);
            this.authorizerConfig(model.authorizerConfig);
            this.serviceType(model.serviceType);
            this.tags(model.tags);
        }

        public final String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getServerCertificateArns() {
            return this.serverCertificateArns;
        }

        @Override
        public final Builder serverCertificateArns(Collection<String> serverCertificateArns) {
            this.serverCertificateArns = ServerCertificateArnsCopier.copy(serverCertificateArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificateArns(String ... serverCertificateArns) {
            this.serverCertificateArns(Arrays.asList(serverCertificateArns));
            return this;
        }

        public final void setServerCertificateArns(Collection<String> serverCertificateArns) {
            this.serverCertificateArns = ServerCertificateArnsCopier.copy(serverCertificateArns);
        }

        public final String getValidationCertificateArn() {
            return this.validationCertificateArn;
        }

        @Override
        public final Builder validationCertificateArn(String validationCertificateArn) {
            this.validationCertificateArn = validationCertificateArn;
            return this;
        }

        public final void setValidationCertificateArn(String validationCertificateArn) {
            this.validationCertificateArn = validationCertificateArn;
        }

        public final AuthorizerConfig.Builder getAuthorizerConfig() {
            return this.authorizerConfig != null ? this.authorizerConfig.toBuilder() : null;
        }

        @Override
        public final Builder authorizerConfig(AuthorizerConfig authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        public final void setAuthorizerConfig(AuthorizerConfig.BuilderImpl authorizerConfig) {
            this.authorizerConfig = authorizerConfig != null ? authorizerConfig.build() : null;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainConfigurationRequest build() {
            return new CreateDomainConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainConfigurationRequest> {
        public Builder domainConfigurationName(String var1);

        public Builder domainName(String var1);

        public Builder serverCertificateArns(Collection<String> var1);

        public Builder serverCertificateArns(String ... var1);

        public Builder validationCertificateArn(String var1);

        public Builder authorizerConfig(AuthorizerConfig var1);

        default public Builder authorizerConfig(Consumer<AuthorizerConfig.Builder> authorizerConfig) {
            return this.authorizerConfig((AuthorizerConfig)((AuthorizerConfig.Builder)AuthorizerConfig.builder().applyMutation(authorizerConfig)).build());
        }

        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

