/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.HttpUrlDestinationSummary;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRuleDestinationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRuleDestinationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::arn)).setter(TopicRuleDestinationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::statusAsString)).setter(TopicRuleDestinationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::statusReason)).setter(TopicRuleDestinationSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<HttpUrlDestinationSummary> HTTP_URL_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::httpUrlSummary)).setter(TopicRuleDestinationSummary.setter(Builder::httpUrlSummary)).constructor(HttpUrlDestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, HTTP_URL_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String status;
    private final String statusReason;
    private final HttpUrlDestinationSummary httpUrlSummary;

    private TopicRuleDestinationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.httpUrlSummary = builder.httpUrlSummary;
    }

    public String arn() {
        return this.arn;
    }

    public TopicRuleDestinationStatus status() {
        return TopicRuleDestinationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public HttpUrlDestinationSummary httpUrlSummary() {
        return this.httpUrlSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpUrlSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestinationSummary)) {
            return false;
        }
        TopicRuleDestinationSummary other = (TopicRuleDestinationSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.httpUrlSummary(), other.httpUrlSummary());
    }

    public String toString() {
        return ToString.builder((String)"TopicRuleDestinationSummary").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("HttpUrlSummary", (Object)this.httpUrlSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "httpUrlSummary": {
                return Optional.ofNullable(clazz.cast(this.httpUrlSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestinationSummary, T> g) {
        return obj -> g.apply((TopicRuleDestinationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private String statusReason;
        private HttpUrlDestinationSummary httpUrlSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestinationSummary model) {
            this.arn(model.arn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.httpUrlSummary(model.httpUrlSummary);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicRuleDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final HttpUrlDestinationSummary.Builder getHttpUrlSummary() {
            return this.httpUrlSummary != null ? this.httpUrlSummary.toBuilder() : null;
        }

        @Override
        public final Builder httpUrlSummary(HttpUrlDestinationSummary httpUrlSummary) {
            this.httpUrlSummary = httpUrlSummary;
            return this;
        }

        public final void setHttpUrlSummary(HttpUrlDestinationSummary.BuilderImpl httpUrlSummary) {
            this.httpUrlSummary = httpUrlSummary != null ? httpUrlSummary.build() : null;
        }

        public TopicRuleDestinationSummary build() {
            return new TopicRuleDestinationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRuleDestinationSummary> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(TopicRuleDestinationStatus var1);

        public Builder statusReason(String var1);

        public Builder httpUrlSummary(HttpUrlDestinationSummary var1);

        default public Builder httpUrlSummary(Consumer<HttpUrlDestinationSummary.Builder> httpUrlSummary) {
            return this.httpUrlSummary((HttpUrlDestinationSummary)((HttpUrlDestinationSummary.Builder)HttpUrlDestinationSummary.builder().applyMutation(httpUrlSummary)).build());
        }
    }
}

