/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.BillingGroupNameAndArnListCopier;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillingGroupsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListBillingGroupsResponse> {
    private static final SdkField<List<GroupNameAndArn>> BILLING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListBillingGroupsResponse.getter(ListBillingGroupsResponse::billingGroups)).setter(ListBillingGroupsResponse.setter(Builder::billingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupNameAndArn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBillingGroupsResponse.getter(ListBillingGroupsResponse::nextToken)).setter(ListBillingGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GroupNameAndArn> billingGroups;
    private final String nextToken;

    private ListBillingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.billingGroups = builder.billingGroups;
        this.nextToken = builder.nextToken;
    }

    public boolean hasBillingGroups() {
        return this.billingGroups != null && !(this.billingGroups instanceof SdkAutoConstructList);
    }

    public List<GroupNameAndArn> billingGroups() {
        return this.billingGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupsResponse)) {
            return false;
        }
        ListBillingGroupsResponse other = (ListBillingGroupsResponse)((Object)obj);
        return Objects.equals(this.billingGroups(), other.billingGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListBillingGroupsResponse").add("BillingGroups", this.billingGroups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billingGroups": {
                return Optional.ofNullable(clazz.cast(this.billingGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupsResponse, T> g) {
        return obj -> g.apply((ListBillingGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<GroupNameAndArn> billingGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupsResponse model) {
            super(model);
            this.billingGroups(model.billingGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<GroupNameAndArn.Builder> getBillingGroups() {
            return this.billingGroups != null ? (Collection)this.billingGroups.stream().map(GroupNameAndArn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder billingGroups(Collection<GroupNameAndArn> billingGroups) {
            this.billingGroups = BillingGroupNameAndArnListCopier.copy(billingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroups(GroupNameAndArn ... billingGroups) {
            this.billingGroups(Arrays.asList(billingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroups(Consumer<GroupNameAndArn.Builder> ... billingGroups) {
            this.billingGroups(Stream.of(billingGroups).map(c -> (GroupNameAndArn)((GroupNameAndArn.Builder)GroupNameAndArn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBillingGroups(Collection<GroupNameAndArn.BuilderImpl> billingGroups) {
            this.billingGroups = BillingGroupNameAndArnListCopier.copyFromBuilder(billingGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBillingGroupsResponse build() {
            return new ListBillingGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBillingGroupsResponse> {
        public Builder billingGroups(Collection<GroupNameAndArn> var1);

        public Builder billingGroups(GroupNameAndArn ... var1);

        public Builder billingGroups(Consumer<GroupNameAndArn.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

