/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DeletePolicyVersion operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePolicyVersionRequest extends IotRequest implements
        ToCopyableBuilder<DeletePolicyVersionRequest.Builder, DeletePolicyVersionRequest> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePolicyVersionRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyName").build()).build();

    private static final SdkField<String> POLICY_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePolicyVersionRequest::policyVersionId)).setter(setter(Builder::policyVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyVersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_VERSION_ID_FIELD));

    private final String policyName;

    private final String policyVersionId;

    private DeletePolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyVersionId = builder.policyVersionId;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy version ID.
     * </p>
     * 
     * @return The policy version ID.
     */
    public String policyVersionId() {
        return policyVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePolicyVersionRequest)) {
            return false;
        }
        DeletePolicyVersionRequest other = (DeletePolicyVersionRequest) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyVersionId(), other.policyVersionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePolicyVersionRequest").add("PolicyName", policyName())
                .add("PolicyVersionId", policyVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "policyVersionId":
            return Optional.ofNullable(clazz.cast(policyVersionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePolicyVersionRequest, T> g) {
        return obj -> g.apply((DeletePolicyVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePolicyVersionRequest> {
        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy version ID.
         * </p>
         * 
         * @param policyVersionId
         *        The policy version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionId(String policyVersionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String policyName;

        private String policyVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePolicyVersionRequest model) {
            super(model);
            policyName(model.policyName);
            policyVersionId(model.policyVersionId);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyVersionId() {
            return policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePolicyVersionRequest build() {
            return new DeletePolicyVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
