/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingTypeMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingTypeMetadata> {
    private static final SdkField<Boolean> DEPRECATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ThingTypeMetadata.getter(ThingTypeMetadata::deprecated)).setter(ThingTypeMetadata.setter(Builder::deprecated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecated").build()}).build();
    private static final SdkField<Instant> DEPRECATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ThingTypeMetadata.getter(ThingTypeMetadata::deprecationDate)).setter(ThingTypeMetadata.setter(Builder::deprecationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationDate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ThingTypeMetadata.getter(ThingTypeMetadata::creationDate)).setter(ThingTypeMetadata.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPRECATED_FIELD, DEPRECATION_DATE_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean deprecated;
    private final Instant deprecationDate;
    private final Instant creationDate;

    private ThingTypeMetadata(BuilderImpl builder) {
        this.deprecated = builder.deprecated;
        this.deprecationDate = builder.deprecationDate;
        this.creationDate = builder.creationDate;
    }

    public Boolean deprecated() {
        return this.deprecated;
    }

    public Instant deprecationDate() {
        return this.deprecationDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecated());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeMetadata)) {
            return false;
        }
        ThingTypeMetadata other = (ThingTypeMetadata)obj;
        return Objects.equals(this.deprecated(), other.deprecated()) && Objects.equals(this.deprecationDate(), other.deprecationDate()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"ThingTypeMetadata").add("Deprecated", (Object)this.deprecated()).add("DeprecationDate", (Object)this.deprecationDate()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deprecated": {
                return Optional.ofNullable(clazz.cast(this.deprecated()));
            }
            case "deprecationDate": {
                return Optional.ofNullable(clazz.cast(this.deprecationDate()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingTypeMetadata, T> g) {
        return obj -> g.apply((ThingTypeMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean deprecated;
        private Instant deprecationDate;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeMetadata model) {
            this.deprecated(model.deprecated);
            this.deprecationDate(model.deprecationDate);
            this.creationDate(model.creationDate);
        }

        public final Boolean getDeprecated() {
            return this.deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        public final Instant getDeprecationDate() {
            return this.deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public ThingTypeMetadata build() {
            return new ThingTypeMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingTypeMetadata> {
        public Builder deprecated(Boolean var1);

        public Builder deprecationDate(Instant var1);

        public Builder creationDate(Instant var1);
    }
}

