/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuthResult;
import software.amazon.awssdk.services.iot.model.AuthResultsCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestAuthorizationResponse
extends IotResponse
implements ToCopyableBuilder<Builder, TestAuthorizationResponse> {
    private static final SdkField<List<AuthResult>> AUTH_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TestAuthorizationResponse.getter(TestAuthorizationResponse::authResults)).setter(TestAuthorizationResponse.setter(Builder::authResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_RESULTS_FIELD));
    private final List<AuthResult> authResults;

    private TestAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.authResults = builder.authResults;
    }

    public boolean hasAuthResults() {
        return this.authResults != null && !(this.authResults instanceof SdkAutoConstructList);
    }

    public List<AuthResult> authResults() {
        return this.authResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAuthorizationResponse)) {
            return false;
        }
        TestAuthorizationResponse other = (TestAuthorizationResponse)((Object)obj);
        return Objects.equals(this.authResults(), other.authResults());
    }

    public String toString() {
        return ToString.builder((String)"TestAuthorizationResponse").add("AuthResults", this.authResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authResults": {
                return Optional.ofNullable(clazz.cast(this.authResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestAuthorizationResponse, T> g) {
        return obj -> g.apply((TestAuthorizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<AuthResult> authResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestAuthorizationResponse model) {
            super(model);
            this.authResults(model.authResults);
        }

        public final Collection<AuthResult.Builder> getAuthResults() {
            return this.authResults != null ? (Collection)this.authResults.stream().map(AuthResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authResults(Collection<AuthResult> authResults) {
            this.authResults = AuthResultsCopier.copy(authResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authResults(AuthResult ... authResults) {
            this.authResults(Arrays.asList(authResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authResults(Consumer<AuthResult.Builder> ... authResults) {
            this.authResults(Stream.of(authResults).map(c -> (AuthResult)((AuthResult.Builder)AuthResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthResults(Collection<AuthResult.BuilderImpl> authResults) {
            this.authResults = AuthResultsCopier.copyFromBuilder(authResults);
        }

        @Override
        public TestAuthorizationResponse build() {
            return new TestAuthorizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestAuthorizationResponse> {
        public Builder authResults(Collection<AuthResult> var1);

        public Builder authResults(AuthResult ... var1);

        public Builder authResults(Consumer<AuthResult.Builder> ... var1);
    }
}

