/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityIntegrationSummary;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.IntegrationSummariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCodeSecurityIntegrationsResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListCodeSecurityIntegrationsResponse> {
    private static final SdkField<List<CodeSecurityIntegrationSummary>> INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("integrations").getter(ListCodeSecurityIntegrationsResponse.getter(ListCodeSecurityIntegrationsResponse::integrations)).setter(ListCodeSecurityIntegrationsResponse.setter(Builder::integrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeSecurityIntegrationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCodeSecurityIntegrationsResponse.getter(ListCodeSecurityIntegrationsResponse::nextToken)).setter(ListCodeSecurityIntegrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCodeSecurityIntegrationsResponse.memberNameToFieldInitializer();
    private final List<CodeSecurityIntegrationSummary> integrations;
    private final String nextToken;

    private ListCodeSecurityIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.integrations = builder.integrations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIntegrations() {
        return this.integrations != null && !(this.integrations instanceof SdkAutoConstructList);
    }

    public final List<CodeSecurityIntegrationSummary> integrations() {
        return this.integrations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrations() ? this.integrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeSecurityIntegrationsResponse)) {
            return false;
        }
        ListCodeSecurityIntegrationsResponse other = (ListCodeSecurityIntegrationsResponse)((Object)obj);
        return this.hasIntegrations() == other.hasIntegrations() && Objects.equals(this.integrations(), other.integrations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCodeSecurityIntegrationsResponse").add("Integrations", this.hasIntegrations() ? this.integrations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integrations": {
                return Optional.ofNullable(clazz.cast(this.integrations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("integrations", INTEGRATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCodeSecurityIntegrationsResponse, T> g) {
        return obj -> g.apply((ListCodeSecurityIntegrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<CodeSecurityIntegrationSummary> integrations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeSecurityIntegrationsResponse model) {
            super(model);
            this.integrations(model.integrations);
            this.nextToken(model.nextToken);
        }

        public final List<CodeSecurityIntegrationSummary.Builder> getIntegrations() {
            List<CodeSecurityIntegrationSummary.Builder> result = IntegrationSummariesCopier.copyToBuilder(this.integrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrations(Collection<CodeSecurityIntegrationSummary.BuilderImpl> integrations) {
            this.integrations = IntegrationSummariesCopier.copyFromBuilder(integrations);
        }

        @Override
        public final Builder integrations(Collection<CodeSecurityIntegrationSummary> integrations) {
            this.integrations = IntegrationSummariesCopier.copy(integrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(CodeSecurityIntegrationSummary ... integrations) {
            this.integrations(Arrays.asList(integrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Consumer<CodeSecurityIntegrationSummary.Builder> ... integrations) {
            this.integrations(Stream.of(integrations).map(c -> (CodeSecurityIntegrationSummary)((CodeSecurityIntegrationSummary.Builder)CodeSecurityIntegrationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCodeSecurityIntegrationsResponse build() {
            return new ListCodeSecurityIntegrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCodeSecurityIntegrationsResponse> {
        public Builder integrations(Collection<CodeSecurityIntegrationSummary> var1);

        public Builder integrations(CodeSecurityIntegrationSummary ... var1);

        public Builder integrations(Consumer<CodeSecurityIntegrationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

