/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CodeScanStatus;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityResource;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCodeSecurityScanResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, GetCodeSecurityScanResponse> {
    private static final SdkField<String> SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanId").getter(GetCodeSecurityScanResponse.getter(GetCodeSecurityScanResponse::scanId)).setter(GetCodeSecurityScanResponse.setter(Builder::scanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanId").build()}).build();
    private static final SdkField<CodeSecurityResource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(GetCodeSecurityScanResponse.getter(GetCodeSecurityScanResponse::resource)).setter(GetCodeSecurityScanResponse.setter(Builder::resource)).constructor(CodeSecurityResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(GetCodeSecurityScanResponse.getter(GetCodeSecurityScanResponse::accountId)).setter(GetCodeSecurityScanResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetCodeSecurityScanResponse.getter(GetCodeSecurityScanResponse::statusAsString)).setter(GetCodeSecurityScanResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetCodeSecurityScanResponse.getter(GetCodeSecurityScanResponse::statusReason)).setter(GetCodeSecurityScanResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetCodeSecurityScanResponse.getter(GetCodeSecurityScanResponse::createdAt)).setter(GetCodeSecurityScanResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetCodeSecurityScanResponse.getter(GetCodeSecurityScanResponse::updatedAt)).setter(GetCodeSecurityScanResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> LAST_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastCommitId").getter(GetCodeSecurityScanResponse.getter(GetCodeSecurityScanResponse::lastCommitId)).setter(GetCodeSecurityScanResponse.setter(Builder::lastCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCommitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ID_FIELD, RESOURCE_FIELD, ACCOUNT_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, LAST_COMMIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCodeSecurityScanResponse.memberNameToFieldInitializer();
    private final String scanId;
    private final CodeSecurityResource resource;
    private final String accountId;
    private final String status;
    private final String statusReason;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String lastCommitId;

    private GetCodeSecurityScanResponse(BuilderImpl builder) {
        super(builder);
        this.scanId = builder.scanId;
        this.resource = builder.resource;
        this.accountId = builder.accountId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.lastCommitId = builder.lastCommitId;
    }

    public final String scanId() {
        return this.scanId;
    }

    public final CodeSecurityResource resource() {
        return this.resource;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final CodeScanStatus status() {
        return CodeScanStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String lastCommitId() {
        return this.lastCommitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCommitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCodeSecurityScanResponse)) {
            return false;
        }
        GetCodeSecurityScanResponse other = (GetCodeSecurityScanResponse)((Object)obj);
        return Objects.equals(this.scanId(), other.scanId()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.lastCommitId(), other.lastCommitId());
    }

    public final String toString() {
        return ToString.builder((String)"GetCodeSecurityScanResponse").add("ScanId", (Object)this.scanId()).add("Resource", (Object)this.resource()).add("AccountId", (Object)this.accountId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("LastCommitId", (Object)this.lastCommitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanId": {
                return Optional.ofNullable(clazz.cast(this.scanId()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "lastCommitId": {
                return Optional.ofNullable(clazz.cast(this.lastCommitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanId", SCAN_ID_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("lastCommitId", LAST_COMMIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCodeSecurityScanResponse, T> g) {
        return obj -> g.apply((GetCodeSecurityScanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private String scanId;
        private CodeSecurityResource resource;
        private String accountId;
        private String status;
        private String statusReason;
        private Instant createdAt;
        private Instant updatedAt;
        private String lastCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCodeSecurityScanResponse model) {
            super(model);
            this.scanId(model.scanId);
            this.resource(model.resource);
            this.accountId(model.accountId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.lastCommitId(model.lastCommitId);
        }

        public final String getScanId() {
            return this.scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final CodeSecurityResource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(CodeSecurityResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(CodeSecurityResource resource) {
            this.resource = resource;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeScanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getLastCommitId() {
            return this.lastCommitId;
        }

        public final void setLastCommitId(String lastCommitId) {
            this.lastCommitId = lastCommitId;
        }

        @Override
        public final Builder lastCommitId(String lastCommitId) {
            this.lastCommitId = lastCommitId;
            return this;
        }

        @Override
        public GetCodeSecurityScanResponse build() {
            return new GetCodeSecurityScanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCodeSecurityScanResponse> {
        public Builder scanId(String var1);

        public Builder resource(CodeSecurityResource var1);

        default public Builder resource(Consumer<CodeSecurityResource.Builder> resource) {
            return this.resource((CodeSecurityResource)((CodeSecurityResource.Builder)CodeSecurityResource.builder().applyMutation(resource)).build());
        }

        public Builder accountId(String var1);

        public Builder status(String var1);

        public Builder status(CodeScanStatus var1);

        public Builder statusReason(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder lastCommitId(String var1);
    }
}

