/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Architecture;
import software.amazon.awssdk.services.inspector2.model.ArchitectureListCopier;
import software.amazon.awssdk.services.inspector2.model.LambdaVpcConfig;
import software.amazon.awssdk.services.inspector2.model.LayerListCopier;
import software.amazon.awssdk.services.inspector2.model.PackageType;
import software.amazon.awssdk.services.inspector2.model.Runtime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsLambdaFunctionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsLambdaFunctionDetails> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionName").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::functionName)).setter(AwsLambdaFunctionDetails.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::runtimeAsString)).setter(AwsLambdaFunctionDetails.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeSha256").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::codeSha256)).setter(AwsLambdaFunctionDetails.setter(Builder::codeSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSha256").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::version)).setter(AwsLambdaFunctionDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::executionRoleArn)).setter(AwsLambdaFunctionDetails.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<List<String>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("layers").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::layers)).setter(AwsLambdaFunctionDetails.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LambdaVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::vpcConfig)).setter(AwsLambdaFunctionDetails.setter(Builder::vpcConfig)).constructor(LambdaVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageType").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::packageTypeAsString)).setter(AwsLambdaFunctionDetails.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageType").build()}).build();
    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("architectures").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::architecturesAsStrings)).setter(AwsLambdaFunctionDetails.setter(Builder::architecturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::lastModifiedAt)).setter(AwsLambdaFunctionDetails.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, RUNTIME_FIELD, CODE_SHA256_FIELD, VERSION_FIELD, EXECUTION_ROLE_ARN_FIELD, LAYERS_FIELD, VPC_CONFIG_FIELD, PACKAGE_TYPE_FIELD, ARCHITECTURES_FIELD, LAST_MODIFIED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsLambdaFunctionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String functionName;
    private final String runtime;
    private final String codeSha256;
    private final String version;
    private final String executionRoleArn;
    private final List<String> layers;
    private final LambdaVpcConfig vpcConfig;
    private final String packageType;
    private final List<String> architectures;
    private final Instant lastModifiedAt;

    private AwsLambdaFunctionDetails(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.runtime = builder.runtime;
        this.codeSha256 = builder.codeSha256;
        this.version = builder.version;
        this.executionRoleArn = builder.executionRoleArn;
        this.layers = builder.layers;
        this.vpcConfig = builder.vpcConfig;
        this.packageType = builder.packageType;
        this.architectures = builder.architectures;
        this.lastModifiedAt = builder.lastModifiedAt;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final String codeSha256() {
        return this.codeSha256;
    }

    public final String version() {
        return this.version;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public final List<String> layers() {
        return this.layers;
    }

    public final LambdaVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public final String packageTypeAsString() {
        return this.packageType;
    }

    public final List<Architecture> architectures() {
        return ArchitectureListCopier.copyStringToEnum(this.architectures);
    }

    public final boolean hasArchitectures() {
        return this.architectures != null && !(this.architectures instanceof SdkAutoConstructList);
    }

    public final List<String> architecturesAsStrings() {
        return this.architectures;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayers() ? this.layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectures() ? this.architecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaFunctionDetails)) {
            return false;
        }
        AwsLambdaFunctionDetails other = (AwsLambdaFunctionDetails)obj;
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.codeSha256(), other.codeSha256()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && this.hasLayers() == other.hasLayers() && Objects.equals(this.layers(), other.layers()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && this.hasArchitectures() == other.hasArchitectures() && Objects.equals(this.architecturesAsStrings(), other.architecturesAsStrings()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AwsLambdaFunctionDetails").add("FunctionName", (Object)this.functionName()).add("Runtime", (Object)this.runtimeAsString()).add("CodeSha256", (Object)this.codeSha256()).add("Version", (Object)this.version()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Layers", this.hasLayers() ? this.layers() : null).add("VpcConfig", (Object)this.vpcConfig()).add("PackageType", (Object)this.packageTypeAsString()).add("Architectures", this.hasArchitectures() ? this.architecturesAsStrings() : null).add("LastModifiedAt", (Object)this.lastModifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "codeSha256": {
                return Optional.ofNullable(clazz.cast(this.codeSha256()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "packageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "architectures": {
                return Optional.ofNullable(clazz.cast(this.architecturesAsStrings()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("functionName", FUNCTION_NAME_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("codeSha256", CODE_SHA256_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("layers", LAYERS_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("packageType", PACKAGE_TYPE_FIELD);
        map.put("architectures", ARCHITECTURES_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaFunctionDetails, T> g) {
        return obj -> g.apply((AwsLambdaFunctionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String runtime;
        private String codeSha256;
        private String version;
        private String executionRoleArn;
        private List<String> layers = DefaultSdkAutoConstructList.getInstance();
        private LambdaVpcConfig vpcConfig;
        private String packageType;
        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaFunctionDetails model) {
            this.functionName(model.functionName);
            this.runtime(model.runtime);
            this.codeSha256(model.codeSha256);
            this.version(model.version);
            this.executionRoleArn(model.executionRoleArn);
            this.layers(model.layers);
            this.vpcConfig(model.vpcConfig);
            this.packageType(model.packageType);
            this.architecturesWithStrings(model.architectures);
            this.lastModifiedAt(model.lastModifiedAt);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Collection<String> getLayers() {
            if (this.layers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.layers;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        public final LambdaVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(LambdaVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(LambdaVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (this.architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
        }

        @Override
        public final Builder architecturesWithStrings(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architecturesWithStrings(String ... architectures) {
            this.architecturesWithStrings(Arrays.asList(architectures));
            return this;
        }

        @Override
        public final Builder architectures(Collection<Architecture> architectures) {
            this.architectures = ArchitectureListCopier.copyEnumToString(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(Architecture ... architectures) {
            this.architectures(Arrays.asList(architectures));
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public AwsLambdaFunctionDetails build() {
            return new AwsLambdaFunctionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsLambdaFunctionDetails> {
        public Builder functionName(String var1);

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder codeSha256(String var1);

        public Builder version(String var1);

        public Builder executionRoleArn(String var1);

        public Builder layers(Collection<String> var1);

        public Builder layers(String ... var1);

        public Builder vpcConfig(LambdaVpcConfig var1);

        default public Builder vpcConfig(Consumer<LambdaVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((LambdaVpcConfig)((LambdaVpcConfig.Builder)LambdaVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder architecturesWithStrings(Collection<String> var1);

        public Builder architecturesWithStrings(String ... var1);

        public Builder architectures(Collection<Architecture> var1);

        public Builder architectures(Architecture ... var1);

        public Builder lastModifiedAt(Instant var1);
    }
}

