/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.SeverityCounts;
import software.amazon.awssdk.services.inspector2.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcrContainerAggregationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcrContainerAggregationResponse> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::resourceId)).setter(AwsEcrContainerAggregationResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> IMAGE_SHA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSha").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::imageSha)).setter(AwsEcrContainerAggregationResponse.setter(Builder::imageSha)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSha").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::repository)).setter(AwsEcrContainerAggregationResponse.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("architecture").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::architecture)).setter(AwsEcrContainerAggregationResponse.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageTags").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::imageTags)).setter(AwsEcrContainerAggregationResponse.setter(Builder::imageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::accountId)).setter(AwsEcrContainerAggregationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("severityCounts").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::severityCounts)).setter(AwsEcrContainerAggregationResponse.setter(Builder::severityCounts)).constructor(SeverityCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()}).build();
    private static final SdkField<Instant> LAST_IN_USE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastInUseAt").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::lastInUseAt)).setter(AwsEcrContainerAggregationResponse.setter(Builder::lastInUseAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastInUseAt").build()}).build();
    private static final SdkField<Long> IN_USE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("inUseCount").getter(AwsEcrContainerAggregationResponse.getter(AwsEcrContainerAggregationResponse::inUseCount)).setter(AwsEcrContainerAggregationResponse.setter(Builder::inUseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inUseCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, IMAGE_SHA_FIELD, REPOSITORY_FIELD, ARCHITECTURE_FIELD, IMAGE_TAGS_FIELD, ACCOUNT_ID_FIELD, SEVERITY_COUNTS_FIELD, LAST_IN_USE_AT_FIELD, IN_USE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEcrContainerAggregationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String imageSha;
    private final String repository;
    private final String architecture;
    private final List<String> imageTags;
    private final String accountId;
    private final SeverityCounts severityCounts;
    private final Instant lastInUseAt;
    private final Long inUseCount;

    private AwsEcrContainerAggregationResponse(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.imageSha = builder.imageSha;
        this.repository = builder.repository;
        this.architecture = builder.architecture;
        this.imageTags = builder.imageTags;
        this.accountId = builder.accountId;
        this.severityCounts = builder.severityCounts;
        this.lastInUseAt = builder.lastInUseAt;
        this.inUseCount = builder.inUseCount;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String imageSha() {
        return this.imageSha;
    }

    public final String repository() {
        return this.repository;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final boolean hasImageTags() {
        return this.imageTags != null && !(this.imageTags instanceof SdkAutoConstructList);
    }

    public final List<String> imageTags() {
        return this.imageTags;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final SeverityCounts severityCounts() {
        return this.severityCounts;
    }

    public final Instant lastInUseAt() {
        return this.lastInUseAt;
    }

    public final Long inUseCount() {
        return this.inUseCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSha());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageTags() ? this.imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastInUseAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrContainerAggregationResponse)) {
            return false;
        }
        AwsEcrContainerAggregationResponse other = (AwsEcrContainerAggregationResponse)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.imageSha(), other.imageSha()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.architecture(), other.architecture()) && this.hasImageTags() == other.hasImageTags() && Objects.equals(this.imageTags(), other.imageTags()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.severityCounts(), other.severityCounts()) && Objects.equals(this.lastInUseAt(), other.lastInUseAt()) && Objects.equals(this.inUseCount(), other.inUseCount());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcrContainerAggregationResponse").add("ResourceId", (Object)this.resourceId()).add("ImageSha", (Object)this.imageSha()).add("Repository", (Object)this.repository()).add("Architecture", (Object)this.architecture()).add("ImageTags", this.hasImageTags() ? this.imageTags() : null).add("AccountId", (Object)this.accountId()).add("SeverityCounts", (Object)this.severityCounts()).add("LastInUseAt", (Object)this.lastInUseAt()).add("InUseCount", (Object)this.inUseCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "imageSha": {
                return Optional.ofNullable(clazz.cast(this.imageSha()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "imageTags": {
                return Optional.ofNullable(clazz.cast(this.imageTags()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "severityCounts": {
                return Optional.ofNullable(clazz.cast(this.severityCounts()));
            }
            case "lastInUseAt": {
                return Optional.ofNullable(clazz.cast(this.lastInUseAt()));
            }
            case "inUseCount": {
                return Optional.ofNullable(clazz.cast(this.inUseCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("imageSha", IMAGE_SHA_FIELD);
        map.put("repository", REPOSITORY_FIELD);
        map.put("architecture", ARCHITECTURE_FIELD);
        map.put("imageTags", IMAGE_TAGS_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        map.put("lastInUseAt", LAST_IN_USE_AT_FIELD);
        map.put("inUseCount", IN_USE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrContainerAggregationResponse, T> g) {
        return obj -> g.apply((AwsEcrContainerAggregationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String imageSha;
        private String repository;
        private String architecture;
        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();
        private String accountId;
        private SeverityCounts severityCounts;
        private Instant lastInUseAt;
        private Long inUseCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrContainerAggregationResponse model) {
            this.resourceId(model.resourceId);
            this.imageSha(model.imageSha);
            this.repository(model.repository);
            this.architecture(model.architecture);
            this.imageTags(model.imageTags);
            this.accountId(model.accountId);
            this.severityCounts(model.severityCounts);
            this.lastInUseAt(model.lastInUseAt);
            this.inUseCount(model.inUseCount);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getImageSha() {
            return this.imageSha;
        }

        public final void setImageSha(String imageSha) {
            this.imageSha = imageSha;
        }

        @Override
        public final Builder imageSha(String imageSha) {
            this.imageSha = imageSha;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final Collection<String> getImageTags() {
            if (this.imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = StringListCopier.copy(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = StringListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return this.severityCounts != null ? this.severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public final Instant getLastInUseAt() {
            return this.lastInUseAt;
        }

        public final void setLastInUseAt(Instant lastInUseAt) {
            this.lastInUseAt = lastInUseAt;
        }

        @Override
        public final Builder lastInUseAt(Instant lastInUseAt) {
            this.lastInUseAt = lastInUseAt;
            return this;
        }

        public final Long getInUseCount() {
            return this.inUseCount;
        }

        public final void setInUseCount(Long inUseCount) {
            this.inUseCount = inUseCount;
        }

        @Override
        public final Builder inUseCount(Long inUseCount) {
            this.inUseCount = inUseCount;
            return this;
        }

        public AwsEcrContainerAggregationResponse build() {
            return new AwsEcrContainerAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcrContainerAggregationResponse> {
        public Builder resourceId(String var1);

        public Builder imageSha(String var1);

        public Builder repository(String var1);

        public Builder architecture(String var1);

        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder accountId(String var1);

        public Builder severityCounts(SeverityCounts var1);

        default public Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return this.severityCounts((SeverityCounts)((SeverityCounts.Builder)SeverityCounts.builder().applyMutation(severityCounts)).build());
        }

        public Builder lastInUseAt(Instant var1);

        public Builder inUseCount(Long var1);
    }
}

