/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Ec2ConfigurationState;
import software.amazon.awssdk.services.inspector2.model.EcrConfigurationState;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigurationResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, GetConfigurationResponse> {
    private static final SdkField<Ec2ConfigurationState> EC2_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2Configuration").getter(GetConfigurationResponse.getter(GetConfigurationResponse::ec2Configuration)).setter(GetConfigurationResponse.setter(Builder::ec2Configuration)).constructor(Ec2ConfigurationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Configuration").build()}).build();
    private static final SdkField<EcrConfigurationState> ECR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecrConfiguration").getter(GetConfigurationResponse.getter(GetConfigurationResponse::ecrConfiguration)).setter(GetConfigurationResponse.setter(Builder::ecrConfiguration)).constructor(EcrConfigurationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_CONFIGURATION_FIELD, ECR_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ec2Configuration", EC2_CONFIGURATION_FIELD);
            this.put("ecrConfiguration", ECR_CONFIGURATION_FIELD);
        }
    });
    private final Ec2ConfigurationState ec2Configuration;
    private final EcrConfigurationState ecrConfiguration;

    private GetConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.ec2Configuration = builder.ec2Configuration;
        this.ecrConfiguration = builder.ecrConfiguration;
    }

    public final Ec2ConfigurationState ec2Configuration() {
        return this.ec2Configuration;
    }

    public final EcrConfigurationState ecrConfiguration() {
        return this.ecrConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationResponse)) {
            return false;
        }
        GetConfigurationResponse other = (GetConfigurationResponse)((Object)obj);
        return Objects.equals(this.ec2Configuration(), other.ec2Configuration()) && Objects.equals(this.ecrConfiguration(), other.ecrConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfigurationResponse").add("Ec2Configuration", (Object)this.ec2Configuration()).add("EcrConfiguration", (Object)this.ecrConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ec2Configuration": {
                return Optional.ofNullable(clazz.cast(this.ec2Configuration()));
            }
            case "ecrConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ecrConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationResponse, T> g) {
        return obj -> g.apply((GetConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private Ec2ConfigurationState ec2Configuration;
        private EcrConfigurationState ecrConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationResponse model) {
            super(model);
            this.ec2Configuration(model.ec2Configuration);
            this.ecrConfiguration(model.ecrConfiguration);
        }

        public final Ec2ConfigurationState.Builder getEc2Configuration() {
            return this.ec2Configuration != null ? this.ec2Configuration.toBuilder() : null;
        }

        public final void setEc2Configuration(Ec2ConfigurationState.BuilderImpl ec2Configuration) {
            this.ec2Configuration = ec2Configuration != null ? ec2Configuration.build() : null;
        }

        @Override
        public final Builder ec2Configuration(Ec2ConfigurationState ec2Configuration) {
            this.ec2Configuration = ec2Configuration;
            return this;
        }

        public final EcrConfigurationState.Builder getEcrConfiguration() {
            return this.ecrConfiguration != null ? this.ecrConfiguration.toBuilder() : null;
        }

        public final void setEcrConfiguration(EcrConfigurationState.BuilderImpl ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration != null ? ecrConfiguration.build() : null;
        }

        @Override
        public final Builder ecrConfiguration(EcrConfigurationState ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration;
            return this;
        }

        @Override
        public GetConfigurationResponse build() {
            return new GetConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigurationResponse> {
        public Builder ec2Configuration(Ec2ConfigurationState var1);

        default public Builder ec2Configuration(Consumer<Ec2ConfigurationState.Builder> ec2Configuration) {
            return this.ec2Configuration((Ec2ConfigurationState)((Ec2ConfigurationState.Builder)Ec2ConfigurationState.builder().applyMutation(ec2Configuration)).build());
        }

        public Builder ecrConfiguration(EcrConfigurationState var1);

        default public Builder ecrConfiguration(Consumer<EcrConfigurationState.Builder> ecrConfiguration) {
            return this.ecrConfiguration((EcrConfigurationState)((EcrConfigurationState.Builder)EcrConfigurationState.builder().applyMutation(ecrConfiguration)).build());
        }
    }
}

