/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.ComputePlatform;
import software.amazon.awssdk.services.inspector2.model.StopCisMessageProgress;
import software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopCisSessionMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StopCisSessionMessage> {
    private static final SdkField<String> BENCHMARK_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("benchmarkProfile").getter(StopCisSessionMessage.getter(StopCisSessionMessage::benchmarkProfile)).setter(StopCisSessionMessage.setter(Builder::benchmarkProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("benchmarkProfile").build()}).build();
    private static final SdkField<String> BENCHMARK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("benchmarkVersion").getter(StopCisSessionMessage.getter(StopCisSessionMessage::benchmarkVersion)).setter(StopCisSessionMessage.setter(Builder::benchmarkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("benchmarkVersion").build()}).build();
    private static final SdkField<ComputePlatform> COMPUTE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computePlatform").getter(StopCisSessionMessage.getter(StopCisSessionMessage::computePlatform)).setter(StopCisSessionMessage.setter(Builder::computePlatform)).constructor(ComputePlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()}).build();
    private static final SdkField<StopCisMessageProgress> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("progress").getter(StopCisSessionMessage.getter(StopCisSessionMessage::progress)).setter(StopCisSessionMessage.setter(Builder::progress)).constructor(StopCisMessageProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progress").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(StopCisSessionMessage.getter(StopCisSessionMessage::reason)).setter(StopCisSessionMessage.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(StopCisSessionMessage.getter(StopCisSessionMessage::statusAsString)).setter(StopCisSessionMessage.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BENCHMARK_PROFILE_FIELD, BENCHMARK_VERSION_FIELD, COMPUTE_PLATFORM_FIELD, PROGRESS_FIELD, REASON_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String benchmarkProfile;
    private final String benchmarkVersion;
    private final ComputePlatform computePlatform;
    private final StopCisMessageProgress progress;
    private final String reason;
    private final String status;

    private StopCisSessionMessage(BuilderImpl builder) {
        this.benchmarkProfile = builder.benchmarkProfile;
        this.benchmarkVersion = builder.benchmarkVersion;
        this.computePlatform = builder.computePlatform;
        this.progress = builder.progress;
        this.reason = builder.reason;
        this.status = builder.status;
    }

    public final String benchmarkProfile() {
        return this.benchmarkProfile;
    }

    public final String benchmarkVersion() {
        return this.benchmarkVersion;
    }

    public final ComputePlatform computePlatform() {
        return this.computePlatform;
    }

    public final StopCisMessageProgress progress() {
        return this.progress;
    }

    public final String reason() {
        return this.reason;
    }

    public final StopCisSessionStatus status() {
        return StopCisSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.benchmarkProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.benchmarkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopCisSessionMessage)) {
            return false;
        }
        StopCisSessionMessage other = (StopCisSessionMessage)obj;
        return Objects.equals(this.benchmarkProfile(), other.benchmarkProfile()) && Objects.equals(this.benchmarkVersion(), other.benchmarkVersion()) && Objects.equals(this.computePlatform(), other.computePlatform()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StopCisSessionMessage").add("BenchmarkProfile", (Object)this.benchmarkProfile()).add("BenchmarkVersion", (Object)this.benchmarkVersion()).add("ComputePlatform", (Object)this.computePlatform()).add("Progress", (Object)this.progress()).add("Reason", (Object)this.reason()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "benchmarkProfile": {
                return Optional.ofNullable(clazz.cast(this.benchmarkProfile()));
            }
            case "benchmarkVersion": {
                return Optional.ofNullable(clazz.cast(this.benchmarkVersion()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatform()));
            }
            case "progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopCisSessionMessage, T> g) {
        return obj -> g.apply((StopCisSessionMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String benchmarkProfile;
        private String benchmarkVersion;
        private ComputePlatform computePlatform;
        private StopCisMessageProgress progress;
        private String reason;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StopCisSessionMessage model) {
            this.benchmarkProfile(model.benchmarkProfile);
            this.benchmarkVersion(model.benchmarkVersion);
            this.computePlatform(model.computePlatform);
            this.progress(model.progress);
            this.reason(model.reason);
            this.status(model.status);
        }

        public final String getBenchmarkProfile() {
            return this.benchmarkProfile;
        }

        public final void setBenchmarkProfile(String benchmarkProfile) {
            this.benchmarkProfile = benchmarkProfile;
        }

        @Override
        public final Builder benchmarkProfile(String benchmarkProfile) {
            this.benchmarkProfile = benchmarkProfile;
            return this;
        }

        public final String getBenchmarkVersion() {
            return this.benchmarkVersion;
        }

        public final void setBenchmarkVersion(String benchmarkVersion) {
            this.benchmarkVersion = benchmarkVersion;
        }

        @Override
        public final Builder benchmarkVersion(String benchmarkVersion) {
            this.benchmarkVersion = benchmarkVersion;
            return this;
        }

        public final ComputePlatform.Builder getComputePlatform() {
            return this.computePlatform != null ? this.computePlatform.toBuilder() : null;
        }

        public final void setComputePlatform(ComputePlatform.BuilderImpl computePlatform) {
            this.computePlatform = computePlatform != null ? computePlatform.build() : null;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        public final StopCisMessageProgress.Builder getProgress() {
            return this.progress != null ? this.progress.toBuilder() : null;
        }

        public final void setProgress(StopCisMessageProgress.BuilderImpl progress) {
            this.progress = progress != null ? progress.build() : null;
        }

        @Override
        public final Builder progress(StopCisMessageProgress progress) {
            this.progress = progress;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StopCisSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public StopCisSessionMessage build() {
            return new StopCisSessionMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StopCisSessionMessage> {
        public Builder benchmarkProfile(String var1);

        public Builder benchmarkVersion(String var1);

        public Builder computePlatform(ComputePlatform var1);

        default public Builder computePlatform(Consumer<ComputePlatform.Builder> computePlatform) {
            return this.computePlatform((ComputePlatform)((ComputePlatform.Builder)ComputePlatform.builder().applyMutation(computePlatform)).build());
        }

        public Builder progress(StopCisMessageProgress var1);

        default public Builder progress(Consumer<StopCisMessageProgress.Builder> progress) {
            return this.progress((StopCisMessageProgress)((StopCisMessageProgress.Builder)StopCisMessageProgress.builder().applyMutation(progress)).build());
        }

        public Builder reason(String var1);

        public Builder status(String var1);

        public Builder status(StopCisSessionStatus var1);
    }
}

