/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AccountIdFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CheckIdFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisNumberFilter;
import software.amazon.awssdk.services.inspector2.model.CisNumberFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter;
import software.amazon.awssdk.services.inspector2.model.CisResultStatusFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisStringFilter;
import software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter;
import software.amazon.awssdk.services.inspector2.model.CisTargetStatusReasonFilter;
import software.amazon.awssdk.services.inspector2.model.PlatformFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.ResourceIdFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.ResourceTagFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.TagFilter;
import software.amazon.awssdk.services.inspector2.model.TargetStatusFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.TargetStatusReasonFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisScanResultsAggregatedByTargetResourceFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisScanResultsAggregatedByTargetResourceFilterCriteria> {
    private static final SdkField<List<CisStringFilter>> ACCOUNT_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIdFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::accountIdFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::accountIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> CHECK_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("checkIdFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::checkIdFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::checkIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisNumberFilter>> FAILED_CHECKS_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedChecksFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::failedChecksFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::failedChecksFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecksFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisNumberFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> PLATFORM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platformFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::platformFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::platformFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisResultStatusFilter>> STATUS_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::statusFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::statusFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisResultStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> TARGET_RESOURCE_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetResourceIdFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::targetResourceIdFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::targetResourceIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagFilter>> TARGET_RESOURCE_TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetResourceTagFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::targetResourceTagFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::targetResourceTagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisTargetStatusFilter>> TARGET_STATUS_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetStatusFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::targetStatusFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::targetStatusFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatusFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisTargetStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisTargetStatusReasonFilter>> TARGET_STATUS_REASON_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetStatusReasonFilters").getter(CisScanResultsAggregatedByTargetResourceFilterCriteria.getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::targetStatusReasonFilters)).setter(CisScanResultsAggregatedByTargetResourceFilterCriteria.setter(Builder::targetStatusReasonFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatusReasonFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisTargetStatusReasonFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FILTERS_FIELD, CHECK_ID_FILTERS_FIELD, FAILED_CHECKS_FILTERS_FIELD, PLATFORM_FILTERS_FIELD, STATUS_FILTERS_FIELD, TARGET_RESOURCE_ID_FILTERS_FIELD, TARGET_RESOURCE_TAG_FILTERS_FIELD, TARGET_STATUS_FILTERS_FIELD, TARGET_STATUS_REASON_FILTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CisStringFilter> accountIdFilters;
    private final List<CisStringFilter> checkIdFilters;
    private final List<CisNumberFilter> failedChecksFilters;
    private final List<CisStringFilter> platformFilters;
    private final List<CisResultStatusFilter> statusFilters;
    private final List<CisStringFilter> targetResourceIdFilters;
    private final List<TagFilter> targetResourceTagFilters;
    private final List<CisTargetStatusFilter> targetStatusFilters;
    private final List<CisTargetStatusReasonFilter> targetStatusReasonFilters;

    private CisScanResultsAggregatedByTargetResourceFilterCriteria(BuilderImpl builder) {
        this.accountIdFilters = builder.accountIdFilters;
        this.checkIdFilters = builder.checkIdFilters;
        this.failedChecksFilters = builder.failedChecksFilters;
        this.platformFilters = builder.platformFilters;
        this.statusFilters = builder.statusFilters;
        this.targetResourceIdFilters = builder.targetResourceIdFilters;
        this.targetResourceTagFilters = builder.targetResourceTagFilters;
        this.targetStatusFilters = builder.targetStatusFilters;
        this.targetStatusReasonFilters = builder.targetStatusReasonFilters;
    }

    public final boolean hasAccountIdFilters() {
        return this.accountIdFilters != null && !(this.accountIdFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> accountIdFilters() {
        return this.accountIdFilters;
    }

    public final boolean hasCheckIdFilters() {
        return this.checkIdFilters != null && !(this.checkIdFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> checkIdFilters() {
        return this.checkIdFilters;
    }

    public final boolean hasFailedChecksFilters() {
        return this.failedChecksFilters != null && !(this.failedChecksFilters instanceof SdkAutoConstructList);
    }

    public final List<CisNumberFilter> failedChecksFilters() {
        return this.failedChecksFilters;
    }

    public final boolean hasPlatformFilters() {
        return this.platformFilters != null && !(this.platformFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> platformFilters() {
        return this.platformFilters;
    }

    public final boolean hasStatusFilters() {
        return this.statusFilters != null && !(this.statusFilters instanceof SdkAutoConstructList);
    }

    public final List<CisResultStatusFilter> statusFilters() {
        return this.statusFilters;
    }

    public final boolean hasTargetResourceIdFilters() {
        return this.targetResourceIdFilters != null && !(this.targetResourceIdFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> targetResourceIdFilters() {
        return this.targetResourceIdFilters;
    }

    public final boolean hasTargetResourceTagFilters() {
        return this.targetResourceTagFilters != null && !(this.targetResourceTagFilters instanceof SdkAutoConstructList);
    }

    public final List<TagFilter> targetResourceTagFilters() {
        return this.targetResourceTagFilters;
    }

    public final boolean hasTargetStatusFilters() {
        return this.targetStatusFilters != null && !(this.targetStatusFilters instanceof SdkAutoConstructList);
    }

    public final List<CisTargetStatusFilter> targetStatusFilters() {
        return this.targetStatusFilters;
    }

    public final boolean hasTargetStatusReasonFilters() {
        return this.targetStatusReasonFilters != null && !(this.targetStatusReasonFilters instanceof SdkAutoConstructList);
    }

    public final List<CisTargetStatusReasonFilter> targetStatusReasonFilters() {
        return this.targetStatusReasonFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIdFilters() ? this.accountIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckIdFilters() ? this.checkIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedChecksFilters() ? this.failedChecksFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformFilters() ? this.platformFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusFilters() ? this.statusFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceIdFilters() ? this.targetResourceIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceTagFilters() ? this.targetResourceTagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetStatusFilters() ? this.targetStatusFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetStatusReasonFilters() ? this.targetStatusReasonFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanResultsAggregatedByTargetResourceFilterCriteria)) {
            return false;
        }
        CisScanResultsAggregatedByTargetResourceFilterCriteria other = (CisScanResultsAggregatedByTargetResourceFilterCriteria)obj;
        return this.hasAccountIdFilters() == other.hasAccountIdFilters() && Objects.equals(this.accountIdFilters(), other.accountIdFilters()) && this.hasCheckIdFilters() == other.hasCheckIdFilters() && Objects.equals(this.checkIdFilters(), other.checkIdFilters()) && this.hasFailedChecksFilters() == other.hasFailedChecksFilters() && Objects.equals(this.failedChecksFilters(), other.failedChecksFilters()) && this.hasPlatformFilters() == other.hasPlatformFilters() && Objects.equals(this.platformFilters(), other.platformFilters()) && this.hasStatusFilters() == other.hasStatusFilters() && Objects.equals(this.statusFilters(), other.statusFilters()) && this.hasTargetResourceIdFilters() == other.hasTargetResourceIdFilters() && Objects.equals(this.targetResourceIdFilters(), other.targetResourceIdFilters()) && this.hasTargetResourceTagFilters() == other.hasTargetResourceTagFilters() && Objects.equals(this.targetResourceTagFilters(), other.targetResourceTagFilters()) && this.hasTargetStatusFilters() == other.hasTargetStatusFilters() && Objects.equals(this.targetStatusFilters(), other.targetStatusFilters()) && this.hasTargetStatusReasonFilters() == other.hasTargetStatusReasonFilters() && Objects.equals(this.targetStatusReasonFilters(), other.targetStatusReasonFilters());
    }

    public final String toString() {
        return ToString.builder((String)"CisScanResultsAggregatedByTargetResourceFilterCriteria").add("AccountIdFilters", this.hasAccountIdFilters() ? this.accountIdFilters() : null).add("CheckIdFilters", this.hasCheckIdFilters() ? this.checkIdFilters() : null).add("FailedChecksFilters", this.hasFailedChecksFilters() ? this.failedChecksFilters() : null).add("PlatformFilters", this.hasPlatformFilters() ? this.platformFilters() : null).add("StatusFilters", this.hasStatusFilters() ? this.statusFilters() : null).add("TargetResourceIdFilters", this.hasTargetResourceIdFilters() ? this.targetResourceIdFilters() : null).add("TargetResourceTagFilters", this.hasTargetResourceTagFilters() ? this.targetResourceTagFilters() : null).add("TargetStatusFilters", this.hasTargetStatusFilters() ? this.targetStatusFilters() : null).add("TargetStatusReasonFilters", this.hasTargetStatusReasonFilters() ? this.targetStatusReasonFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIdFilters": {
                return Optional.ofNullable(clazz.cast(this.accountIdFilters()));
            }
            case "checkIdFilters": {
                return Optional.ofNullable(clazz.cast(this.checkIdFilters()));
            }
            case "failedChecksFilters": {
                return Optional.ofNullable(clazz.cast(this.failedChecksFilters()));
            }
            case "platformFilters": {
                return Optional.ofNullable(clazz.cast(this.platformFilters()));
            }
            case "statusFilters": {
                return Optional.ofNullable(clazz.cast(this.statusFilters()));
            }
            case "targetResourceIdFilters": {
                return Optional.ofNullable(clazz.cast(this.targetResourceIdFilters()));
            }
            case "targetResourceTagFilters": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTagFilters()));
            }
            case "targetStatusFilters": {
                return Optional.ofNullable(clazz.cast(this.targetStatusFilters()));
            }
            case "targetStatusReasonFilters": {
                return Optional.ofNullable(clazz.cast(this.targetStatusReasonFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CisScanResultsAggregatedByTargetResourceFilterCriteria, T> g) {
        return obj -> g.apply((CisScanResultsAggregatedByTargetResourceFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CisStringFilter> accountIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> checkIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisNumberFilter> failedChecksFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> platformFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisResultStatusFilter> statusFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> targetResourceIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<TagFilter> targetResourceTagFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisTargetStatusFilter> targetStatusFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisTargetStatusReasonFilter> targetStatusReasonFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanResultsAggregatedByTargetResourceFilterCriteria model) {
            this.accountIdFilters(model.accountIdFilters);
            this.checkIdFilters(model.checkIdFilters);
            this.failedChecksFilters(model.failedChecksFilters);
            this.platformFilters(model.platformFilters);
            this.statusFilters(model.statusFilters);
            this.targetResourceIdFilters(model.targetResourceIdFilters);
            this.targetResourceTagFilters(model.targetResourceTagFilters);
            this.targetStatusFilters(model.targetStatusFilters);
            this.targetStatusReasonFilters(model.targetStatusReasonFilters);
        }

        public final List<CisStringFilter.Builder> getAccountIdFilters() {
            List<CisStringFilter.Builder> result = AccountIdFilterListCopier.copyToBuilder(this.accountIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIdFilters(Collection<CisStringFilter.BuilderImpl> accountIdFilters) {
            this.accountIdFilters = AccountIdFilterListCopier.copyFromBuilder(accountIdFilters);
        }

        @Override
        public final Builder accountIdFilters(Collection<CisStringFilter> accountIdFilters) {
            this.accountIdFilters = AccountIdFilterListCopier.copy(accountIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilters(CisStringFilter ... accountIdFilters) {
            this.accountIdFilters(Arrays.asList(accountIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilters(Consumer<CisStringFilter.Builder> ... accountIdFilters) {
            this.accountIdFilters(Stream.of(accountIdFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getCheckIdFilters() {
            List<CisStringFilter.Builder> result = CheckIdFilterListCopier.copyToBuilder(this.checkIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckIdFilters(Collection<CisStringFilter.BuilderImpl> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copyFromBuilder(checkIdFilters);
        }

        @Override
        public final Builder checkIdFilters(Collection<CisStringFilter> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copy(checkIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(CisStringFilter ... checkIdFilters) {
            this.checkIdFilters(Arrays.asList(checkIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(Consumer<CisStringFilter.Builder> ... checkIdFilters) {
            this.checkIdFilters(Stream.of(checkIdFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisNumberFilter.Builder> getFailedChecksFilters() {
            List<CisNumberFilter.Builder> result = CisNumberFilterListCopier.copyToBuilder(this.failedChecksFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedChecksFilters(Collection<CisNumberFilter.BuilderImpl> failedChecksFilters) {
            this.failedChecksFilters = CisNumberFilterListCopier.copyFromBuilder(failedChecksFilters);
        }

        @Override
        public final Builder failedChecksFilters(Collection<CisNumberFilter> failedChecksFilters) {
            this.failedChecksFilters = CisNumberFilterListCopier.copy(failedChecksFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedChecksFilters(CisNumberFilter ... failedChecksFilters) {
            this.failedChecksFilters(Arrays.asList(failedChecksFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedChecksFilters(Consumer<CisNumberFilter.Builder> ... failedChecksFilters) {
            this.failedChecksFilters(Stream.of(failedChecksFilters).map(c -> (CisNumberFilter)((CisNumberFilter.Builder)CisNumberFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getPlatformFilters() {
            List<CisStringFilter.Builder> result = PlatformFilterListCopier.copyToBuilder(this.platformFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatformFilters(Collection<CisStringFilter.BuilderImpl> platformFilters) {
            this.platformFilters = PlatformFilterListCopier.copyFromBuilder(platformFilters);
        }

        @Override
        public final Builder platformFilters(Collection<CisStringFilter> platformFilters) {
            this.platformFilters = PlatformFilterListCopier.copy(platformFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformFilters(CisStringFilter ... platformFilters) {
            this.platformFilters(Arrays.asList(platformFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformFilters(Consumer<CisStringFilter.Builder> ... platformFilters) {
            this.platformFilters(Stream.of(platformFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisResultStatusFilter.Builder> getStatusFilters() {
            List<CisResultStatusFilter.Builder> result = CisResultStatusFilterListCopier.copyToBuilder(this.statusFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusFilters(Collection<CisResultStatusFilter.BuilderImpl> statusFilters) {
            this.statusFilters = CisResultStatusFilterListCopier.copyFromBuilder(statusFilters);
        }

        @Override
        public final Builder statusFilters(Collection<CisResultStatusFilter> statusFilters) {
            this.statusFilters = CisResultStatusFilterListCopier.copy(statusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusFilters(CisResultStatusFilter ... statusFilters) {
            this.statusFilters(Arrays.asList(statusFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusFilters(Consumer<CisResultStatusFilter.Builder> ... statusFilters) {
            this.statusFilters(Stream.of(statusFilters).map(c -> (CisResultStatusFilter)((CisResultStatusFilter.Builder)CisResultStatusFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTargetResourceIdFilters() {
            List<CisStringFilter.Builder> result = ResourceIdFilterListCopier.copyToBuilder(this.targetResourceIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceIdFilters(Collection<CisStringFilter.BuilderImpl> targetResourceIdFilters) {
            this.targetResourceIdFilters = ResourceIdFilterListCopier.copyFromBuilder(targetResourceIdFilters);
        }

        @Override
        public final Builder targetResourceIdFilters(Collection<CisStringFilter> targetResourceIdFilters) {
            this.targetResourceIdFilters = ResourceIdFilterListCopier.copy(targetResourceIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceIdFilters(CisStringFilter ... targetResourceIdFilters) {
            this.targetResourceIdFilters(Arrays.asList(targetResourceIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceIdFilters(Consumer<CisStringFilter.Builder> ... targetResourceIdFilters) {
            this.targetResourceIdFilters(Stream.of(targetResourceIdFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getTargetResourceTagFilters() {
            List<TagFilter.Builder> result = ResourceTagFilterListCopier.copyToBuilder(this.targetResourceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceTagFilters(Collection<TagFilter.BuilderImpl> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copyFromBuilder(targetResourceTagFilters);
        }

        @Override
        public final Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copy(targetResourceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(TagFilter ... targetResourceTagFilters) {
            this.targetResourceTagFilters(Arrays.asList(targetResourceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(Consumer<TagFilter.Builder> ... targetResourceTagFilters) {
            this.targetResourceTagFilters(Stream.of(targetResourceTagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisTargetStatusFilter.Builder> getTargetStatusFilters() {
            List<CisTargetStatusFilter.Builder> result = TargetStatusFilterListCopier.copyToBuilder(this.targetStatusFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetStatusFilters(Collection<CisTargetStatusFilter.BuilderImpl> targetStatusFilters) {
            this.targetStatusFilters = TargetStatusFilterListCopier.copyFromBuilder(targetStatusFilters);
        }

        @Override
        public final Builder targetStatusFilters(Collection<CisTargetStatusFilter> targetStatusFilters) {
            this.targetStatusFilters = TargetStatusFilterListCopier.copy(targetStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStatusFilters(CisTargetStatusFilter ... targetStatusFilters) {
            this.targetStatusFilters(Arrays.asList(targetStatusFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStatusFilters(Consumer<CisTargetStatusFilter.Builder> ... targetStatusFilters) {
            this.targetStatusFilters(Stream.of(targetStatusFilters).map(c -> (CisTargetStatusFilter)((CisTargetStatusFilter.Builder)CisTargetStatusFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisTargetStatusReasonFilter.Builder> getTargetStatusReasonFilters() {
            List<CisTargetStatusReasonFilter.Builder> result = TargetStatusReasonFilterListCopier.copyToBuilder(this.targetStatusReasonFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetStatusReasonFilters(Collection<CisTargetStatusReasonFilter.BuilderImpl> targetStatusReasonFilters) {
            this.targetStatusReasonFilters = TargetStatusReasonFilterListCopier.copyFromBuilder(targetStatusReasonFilters);
        }

        @Override
        public final Builder targetStatusReasonFilters(Collection<CisTargetStatusReasonFilter> targetStatusReasonFilters) {
            this.targetStatusReasonFilters = TargetStatusReasonFilterListCopier.copy(targetStatusReasonFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStatusReasonFilters(CisTargetStatusReasonFilter ... targetStatusReasonFilters) {
            this.targetStatusReasonFilters(Arrays.asList(targetStatusReasonFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStatusReasonFilters(Consumer<CisTargetStatusReasonFilter.Builder> ... targetStatusReasonFilters) {
            this.targetStatusReasonFilters(Stream.of(targetStatusReasonFilters).map(c -> (CisTargetStatusReasonFilter)((CisTargetStatusReasonFilter.Builder)CisTargetStatusReasonFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CisScanResultsAggregatedByTargetResourceFilterCriteria build() {
            return new CisScanResultsAggregatedByTargetResourceFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisScanResultsAggregatedByTargetResourceFilterCriteria> {
        public Builder accountIdFilters(Collection<CisStringFilter> var1);

        public Builder accountIdFilters(CisStringFilter ... var1);

        public Builder accountIdFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder checkIdFilters(Collection<CisStringFilter> var1);

        public Builder checkIdFilters(CisStringFilter ... var1);

        public Builder checkIdFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder failedChecksFilters(Collection<CisNumberFilter> var1);

        public Builder failedChecksFilters(CisNumberFilter ... var1);

        public Builder failedChecksFilters(Consumer<CisNumberFilter.Builder> ... var1);

        public Builder platformFilters(Collection<CisStringFilter> var1);

        public Builder platformFilters(CisStringFilter ... var1);

        public Builder platformFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder statusFilters(Collection<CisResultStatusFilter> var1);

        public Builder statusFilters(CisResultStatusFilter ... var1);

        public Builder statusFilters(Consumer<CisResultStatusFilter.Builder> ... var1);

        public Builder targetResourceIdFilters(Collection<CisStringFilter> var1);

        public Builder targetResourceIdFilters(CisStringFilter ... var1);

        public Builder targetResourceIdFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder targetResourceTagFilters(Collection<TagFilter> var1);

        public Builder targetResourceTagFilters(TagFilter ... var1);

        public Builder targetResourceTagFilters(Consumer<TagFilter.Builder> ... var1);

        public Builder targetStatusFilters(Collection<CisTargetStatusFilter> var1);

        public Builder targetStatusFilters(CisTargetStatusFilter ... var1);

        public Builder targetStatusFilters(Consumer<CisTargetStatusFilter.Builder> ... var1);

        public Builder targetStatusReasonFilters(Collection<CisTargetStatusReasonFilter> var1);

        public Builder targetStatusReasonFilters(CisTargetStatusReasonFilter ... var1);

        public Builder targetStatusReasonFilters(Consumer<CisTargetStatusReasonFilter.Builder> ... var1);
    }
}

