/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CisReportFormat;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.ReportTargetAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCisScanReportRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, GetCisScanReportRequest> {
    private static final SdkField<String> REPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportFormat").getter(GetCisScanReportRequest.getter(GetCisScanReportRequest::reportFormatAsString)).setter(GetCisScanReportRequest.setter(Builder::reportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFormat").build()}).build();
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanArn").getter(GetCisScanReportRequest.getter(GetCisScanReportRequest::scanArn)).setter(GetCisScanReportRequest.setter(Builder::scanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()}).build();
    private static final SdkField<List<String>> TARGET_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetAccounts").getter(GetCisScanReportRequest.getter(GetCisScanReportRequest::targetAccounts)).setter(GetCisScanReportRequest.setter(Builder::targetAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_FORMAT_FIELD, SCAN_ARN_FIELD, TARGET_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCisScanReportRequest.memberNameToFieldInitializer();
    private final String reportFormat;
    private final String scanArn;
    private final List<String> targetAccounts;

    private GetCisScanReportRequest(BuilderImpl builder) {
        super(builder);
        this.reportFormat = builder.reportFormat;
        this.scanArn = builder.scanArn;
        this.targetAccounts = builder.targetAccounts;
    }

    public final CisReportFormat reportFormat() {
        return CisReportFormat.fromValue(this.reportFormat);
    }

    public final String reportFormatAsString() {
        return this.reportFormat;
    }

    public final String scanArn() {
        return this.scanArn;
    }

    public final boolean hasTargetAccounts() {
        return this.targetAccounts != null && !(this.targetAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> targetAccounts() {
        return this.targetAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetAccounts() ? this.targetAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCisScanReportRequest)) {
            return false;
        }
        GetCisScanReportRequest other = (GetCisScanReportRequest)((Object)obj);
        return Objects.equals(this.reportFormatAsString(), other.reportFormatAsString()) && Objects.equals(this.scanArn(), other.scanArn()) && this.hasTargetAccounts() == other.hasTargetAccounts() && Objects.equals(this.targetAccounts(), other.targetAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"GetCisScanReportRequest").add("ReportFormat", (Object)this.reportFormatAsString()).add("ScanArn", (Object)this.scanArn()).add("TargetAccounts", this.hasTargetAccounts() ? this.targetAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportFormat": {
                return Optional.ofNullable(clazz.cast(this.reportFormatAsString()));
            }
            case "scanArn": {
                return Optional.ofNullable(clazz.cast(this.scanArn()));
            }
            case "targetAccounts": {
                return Optional.ofNullable(clazz.cast(this.targetAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reportFormat", REPORT_FORMAT_FIELD);
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("targetAccounts", TARGET_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCisScanReportRequest, T> g) {
        return obj -> g.apply((GetCisScanReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private String reportFormat;
        private String scanArn;
        private List<String> targetAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCisScanReportRequest model) {
            super(model);
            this.reportFormat(model.reportFormat);
            this.scanArn(model.scanArn);
            this.targetAccounts(model.targetAccounts);
        }

        public final String getReportFormat() {
            return this.reportFormat;
        }

        public final void setReportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
        }

        @Override
        public final Builder reportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        @Override
        public final Builder reportFormat(CisReportFormat reportFormat) {
            this.reportFormat(reportFormat == null ? null : reportFormat.toString());
            return this;
        }

        public final String getScanArn() {
            return this.scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final Collection<String> getTargetAccounts() {
            if (this.targetAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetAccounts;
        }

        public final void setTargetAccounts(Collection<String> targetAccounts) {
            this.targetAccounts = ReportTargetAccountsCopier.copy(targetAccounts);
        }

        @Override
        public final Builder targetAccounts(Collection<String> targetAccounts) {
            this.targetAccounts = ReportTargetAccountsCopier.copy(targetAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccounts(String ... targetAccounts) {
            this.targetAccounts(Arrays.asList(targetAccounts));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCisScanReportRequest build() {
            return new GetCisScanReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCisScanReportRequest> {
        public Builder reportFormat(String var1);

        public Builder reportFormat(CisReportFormat var1);

        public Builder scanArn(String var1);

        public Builder targetAccounts(Collection<String> var1);

        public Builder targetAccounts(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

