/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse;
import software.amazon.awssdk.services.inspector2.model.UsageTotal;

public class ListUsageTotalsPublisher
implements SdkPublisher<ListUsageTotalsResponse> {
    private final Inspector2AsyncClient client;
    private final ListUsageTotalsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUsageTotalsPublisher(Inspector2AsyncClient client, ListUsageTotalsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUsageTotalsPublisher(Inspector2AsyncClient client, ListUsageTotalsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUsageTotalsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUsageTotalsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UsageTotal> totals() {
        Function<ListUsageTotalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.totals() != null) {
                return response.totals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUsageTotalsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUsageTotalsResponseFetcher
    implements AsyncPageFetcher<ListUsageTotalsResponse> {
        private ListUsageTotalsResponseFetcher() {
        }

        public boolean hasNextPage(ListUsageTotalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUsageTotalsResponse> nextPage(ListUsageTotalsResponse previousPage) {
            if (previousPage == null) {
                return ListUsageTotalsPublisher.this.client.listUsageTotals(ListUsageTotalsPublisher.this.firstRequest);
            }
            return ListUsageTotalsPublisher.this.client.listUsageTotals((ListUsageTotalsRequest)((Object)ListUsageTotalsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

