/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GroupKey {
    SCAN_STATUS_CODE("SCAN_STATUS_CODE"),
    SCAN_STATUS_REASON("SCAN_STATUS_REASON"),
    ACCOUNT_ID("ACCOUNT_ID"),
    RESOURCE_TYPE("RESOURCE_TYPE"),
    ECR_REPOSITORY_NAME("ECR_REPOSITORY_NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GroupKey> VALUE_MAP;
    private final String value;

    private GroupKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GroupKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GroupKey> knownValues() {
        EnumSet<GroupKey> knownValues = EnumSet.allOf(GroupKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GroupKey.class, GroupKey::toString);
    }
}

