/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Ec2InstanceSortBy {
    NETWORK_FINDINGS("NETWORK_FINDINGS"),
    CRITICAL("CRITICAL"),
    HIGH("HIGH"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Ec2InstanceSortBy> VALUE_MAP;
    private final String value;

    private Ec2InstanceSortBy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Ec2InstanceSortBy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Ec2InstanceSortBy> knownValues() {
        EnumSet<Ec2InstanceSortBy> knownValues = EnumSet.allOf(Ec2InstanceSortBy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Ec2InstanceSortBy.class, Ec2InstanceSortBy::toString);
    }
}

