/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CisScanStatus;
import software.amazon.awssdk.services.inspector2.model.CisSecurityLevel;
import software.amazon.awssdk.services.inspector2.model.CisTargets;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisScan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisScan> {
    private static final SdkField<Integer> FAILED_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failedChecks").getter(CisScan.getter(CisScan::failedChecks)).setter(CisScan.setter(Builder::failedChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecks").build()}).build();
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanArn").getter(CisScan.getter(CisScan::scanArn)).setter(CisScan.setter(Builder::scanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()}).build();
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanConfigurationArn").getter(CisScan.getter(CisScan::scanConfigurationArn)).setter(CisScan.setter(Builder::scanConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build()}).build();
    private static final SdkField<Instant> SCAN_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("scanDate").getter(CisScan.getter(CisScan::scanDate)).setter(CisScan.setter(Builder::scanDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanDate").build()}).build();
    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanName").getter(CisScan.getter(CisScan::scanName)).setter(CisScan.setter(Builder::scanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()}).build();
    private static final SdkField<String> SCHEDULED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledBy").getter(CisScan.getter(CisScan::scheduledBy)).setter(CisScan.setter(Builder::scheduledBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledBy").build()}).build();
    private static final SdkField<String> SECURITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityLevel").getter(CisScan.getter(CisScan::securityLevelAsString)).setter(CisScan.setter(Builder::securityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevel").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CisScan.getter(CisScan::statusAsString)).setter(CisScan.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<CisTargets> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targets").getter(CisScan.getter(CisScan::targets)).setter(CisScan.setter(Builder::targets)).constructor(CisTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build()}).build();
    private static final SdkField<Integer> TOTAL_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalChecks").getter(CisScan.getter(CisScan::totalChecks)).setter(CisScan.setter(Builder::totalChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalChecks").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_CHECKS_FIELD, SCAN_ARN_FIELD, SCAN_CONFIGURATION_ARN_FIELD, SCAN_DATE_FIELD, SCAN_NAME_FIELD, SCHEDULED_BY_FIELD, SECURITY_LEVEL_FIELD, STATUS_FIELD, TARGETS_FIELD, TOTAL_CHECKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer failedChecks;
    private final String scanArn;
    private final String scanConfigurationArn;
    private final Instant scanDate;
    private final String scanName;
    private final String scheduledBy;
    private final String securityLevel;
    private final String status;
    private final CisTargets targets;
    private final Integer totalChecks;

    private CisScan(BuilderImpl builder) {
        this.failedChecks = builder.failedChecks;
        this.scanArn = builder.scanArn;
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.scanDate = builder.scanDate;
        this.scanName = builder.scanName;
        this.scheduledBy = builder.scheduledBy;
        this.securityLevel = builder.securityLevel;
        this.status = builder.status;
        this.targets = builder.targets;
        this.totalChecks = builder.totalChecks;
    }

    public final Integer failedChecks() {
        return this.failedChecks;
    }

    public final String scanArn() {
        return this.scanArn;
    }

    public final String scanConfigurationArn() {
        return this.scanConfigurationArn;
    }

    public final Instant scanDate() {
        return this.scanDate;
    }

    public final String scanName() {
        return this.scanName;
    }

    public final String scheduledBy() {
        return this.scheduledBy;
    }

    public final CisSecurityLevel securityLevel() {
        return CisSecurityLevel.fromValue(this.securityLevel);
    }

    public final String securityLevelAsString() {
        return this.securityLevel;
    }

    public final CisScanStatus status() {
        return CisScanStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CisTargets targets() {
        return this.targets;
    }

    public final Integer totalChecks() {
        return this.totalChecks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalChecks());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScan)) {
            return false;
        }
        CisScan other = (CisScan)obj;
        return Objects.equals(this.failedChecks(), other.failedChecks()) && Objects.equals(this.scanArn(), other.scanArn()) && Objects.equals(this.scanConfigurationArn(), other.scanConfigurationArn()) && Objects.equals(this.scanDate(), other.scanDate()) && Objects.equals(this.scanName(), other.scanName()) && Objects.equals(this.scheduledBy(), other.scheduledBy()) && Objects.equals(this.securityLevelAsString(), other.securityLevelAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.totalChecks(), other.totalChecks());
    }

    public final String toString() {
        return ToString.builder((String)"CisScan").add("FailedChecks", (Object)this.failedChecks()).add("ScanArn", (Object)this.scanArn()).add("ScanConfigurationArn", (Object)this.scanConfigurationArn()).add("ScanDate", (Object)this.scanDate()).add("ScanName", (Object)this.scanName()).add("ScheduledBy", (Object)this.scheduledBy()).add("SecurityLevel", (Object)this.securityLevelAsString()).add("Status", (Object)this.statusAsString()).add("Targets", (Object)this.targets()).add("TotalChecks", (Object)this.totalChecks()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failedChecks": {
                return Optional.ofNullable(clazz.cast(this.failedChecks()));
            }
            case "scanArn": {
                return Optional.ofNullable(clazz.cast(this.scanArn()));
            }
            case "scanConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.scanConfigurationArn()));
            }
            case "scanDate": {
                return Optional.ofNullable(clazz.cast(this.scanDate()));
            }
            case "scanName": {
                return Optional.ofNullable(clazz.cast(this.scanName()));
            }
            case "scheduledBy": {
                return Optional.ofNullable(clazz.cast(this.scheduledBy()));
            }
            case "securityLevel": {
                return Optional.ofNullable(clazz.cast(this.securityLevelAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "totalChecks": {
                return Optional.ofNullable(clazz.cast(this.totalChecks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CisScan, T> g) {
        return obj -> g.apply((CisScan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer failedChecks;
        private String scanArn;
        private String scanConfigurationArn;
        private Instant scanDate;
        private String scanName;
        private String scheduledBy;
        private String securityLevel;
        private String status;
        private CisTargets targets;
        private Integer totalChecks;

        private BuilderImpl() {
        }

        private BuilderImpl(CisScan model) {
            this.failedChecks(model.failedChecks);
            this.scanArn(model.scanArn);
            this.scanConfigurationArn(model.scanConfigurationArn);
            this.scanDate(model.scanDate);
            this.scanName(model.scanName);
            this.scheduledBy(model.scheduledBy);
            this.securityLevel(model.securityLevel);
            this.status(model.status);
            this.targets(model.targets);
            this.totalChecks(model.totalChecks);
        }

        public final Integer getFailedChecks() {
            return this.failedChecks;
        }

        public final void setFailedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
        }

        @Override
        public final Builder failedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
            return this;
        }

        public final String getScanArn() {
            return this.scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getScanConfigurationArn() {
            return this.scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final Instant getScanDate() {
            return this.scanDate;
        }

        public final void setScanDate(Instant scanDate) {
            this.scanDate = scanDate;
        }

        @Override
        public final Builder scanDate(Instant scanDate) {
            this.scanDate = scanDate;
            return this;
        }

        public final String getScanName() {
            return this.scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final String getScheduledBy() {
            return this.scheduledBy;
        }

        public final void setScheduledBy(String scheduledBy) {
            this.scheduledBy = scheduledBy;
        }

        @Override
        public final Builder scheduledBy(String scheduledBy) {
            this.scheduledBy = scheduledBy;
            return this;
        }

        public final String getSecurityLevel() {
            return this.securityLevel;
        }

        public final void setSecurityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
        }

        @Override
        public final Builder securityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        @Override
        public final Builder securityLevel(CisSecurityLevel securityLevel) {
            this.securityLevel(securityLevel == null ? null : securityLevel.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CisScanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final CisTargets.Builder getTargets() {
            return this.targets != null ? this.targets.toBuilder() : null;
        }

        public final void setTargets(CisTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        public final Builder targets(CisTargets targets) {
            this.targets = targets;
            return this;
        }

        public final Integer getTotalChecks() {
            return this.totalChecks;
        }

        public final void setTotalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
        }

        @Override
        public final Builder totalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
            return this;
        }

        public CisScan build() {
            return new CisScan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisScan> {
        public Builder failedChecks(Integer var1);

        public Builder scanArn(String var1);

        public Builder scanConfigurationArn(String var1);

        public Builder scanDate(Instant var1);

        public Builder scanName(String var1);

        public Builder scheduledBy(String var1);

        public Builder securityLevel(String var1);

        public Builder securityLevel(CisSecurityLevel var1);

        public Builder status(String var1);

        public Builder status(CisScanStatus var1);

        public Builder targets(CisTargets var1);

        default public Builder targets(Consumer<CisTargets.Builder> targets) {
            return this.targets((CisTargets)((CisTargets.Builder)CisTargets.builder().applyMutation(targets)).build());
        }

        public Builder totalChecks(Integer var1);
    }
}

