/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the state of Amazon Inspector deep inspection for a member account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberAccountEc2DeepInspectionStatusState implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberAccountEc2DeepInspectionStatusState.Builder, MemberAccountEc2DeepInspectionStatusState> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(MemberAccountEc2DeepInspectionStatusState::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(MemberAccountEc2DeepInspectionStatusState::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MemberAccountEc2DeepInspectionStatusState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ERROR_MESSAGE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String errorMessage;

    private final String status;

    private MemberAccountEc2DeepInspectionStatusState(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.errorMessage = builder.errorMessage;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Web Services account of the organization member
     * </p>
     * 
     * @return The unique identifier for the Amazon Web Services account of the organization member
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The error message explaining why the account failed to activate Amazon Inspector deep inspection.
     * </p>
     * 
     * @return The error message explaining why the account failed to activate Amazon Inspector deep inspection.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The state of Amazon Inspector deep inspection in the member account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Ec2DeepInspectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of Amazon Inspector deep inspection in the member account.
     * @see Ec2DeepInspectionStatus
     */
    public final Ec2DeepInspectionStatus status() {
        return Ec2DeepInspectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of Amazon Inspector deep inspection in the member account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Ec2DeepInspectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of Amazon Inspector deep inspection in the member account.
     * @see Ec2DeepInspectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberAccountEc2DeepInspectionStatusState)) {
            return false;
        }
        MemberAccountEc2DeepInspectionStatusState other = (MemberAccountEc2DeepInspectionStatusState) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberAccountEc2DeepInspectionStatusState").add("AccountId", accountId())
                .add("ErrorMessage", errorMessage()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberAccountEc2DeepInspectionStatusState, T> g) {
        return obj -> g.apply((MemberAccountEc2DeepInspectionStatusState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberAccountEc2DeepInspectionStatusState> {
        /**
         * <p>
         * The unique identifier for the Amazon Web Services account of the organization member
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the Amazon Web Services account of the organization member
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The error message explaining why the account failed to activate Amazon Inspector deep inspection.
         * </p>
         * 
         * @param errorMessage
         *        The error message explaining why the account failed to activate Amazon Inspector deep inspection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The state of Amazon Inspector deep inspection in the member account.
         * </p>
         * 
         * @param status
         *        The state of Amazon Inspector deep inspection in the member account.
         * @see Ec2DeepInspectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2DeepInspectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of Amazon Inspector deep inspection in the member account.
         * </p>
         * 
         * @param status
         *        The state of Amazon Inspector deep inspection in the member account.
         * @see Ec2DeepInspectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2DeepInspectionStatus
         */
        Builder status(Ec2DeepInspectionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String errorMessage;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberAccountEc2DeepInspectionStatusState model) {
            accountId(model.accountId);
            errorMessage(model.errorMessage);
            status(model.status);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Ec2DeepInspectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public MemberAccountEc2DeepInspectionStatusState build() {
            return new MemberAccountEc2DeepInspectionStatusState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
