/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDelegatedAdminAccountResponse extends Inspector2Response implements
        ToCopyableBuilder<GetDelegatedAdminAccountResponse.Builder, GetDelegatedAdminAccountResponse> {
    private static final SdkField<DelegatedAdmin> DELEGATED_ADMIN_FIELD = SdkField
            .<DelegatedAdmin> builder(MarshallingType.SDK_POJO).memberName("delegatedAdmin")
            .getter(getter(GetDelegatedAdminAccountResponse::delegatedAdmin)).setter(setter(Builder::delegatedAdmin))
            .constructor(DelegatedAdmin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegatedAdmin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATED_ADMIN_FIELD));

    private final DelegatedAdmin delegatedAdmin;

    private GetDelegatedAdminAccountResponse(BuilderImpl builder) {
        super(builder);
        this.delegatedAdmin = builder.delegatedAdmin;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the Amazon Inspector delegated administrator.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the Amazon Inspector delegated administrator.
     */
    public final DelegatedAdmin delegatedAdmin() {
        return delegatedAdmin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(delegatedAdmin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDelegatedAdminAccountResponse)) {
            return false;
        }
        GetDelegatedAdminAccountResponse other = (GetDelegatedAdminAccountResponse) obj;
        return Objects.equals(delegatedAdmin(), other.delegatedAdmin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDelegatedAdminAccountResponse").add("DelegatedAdmin", delegatedAdmin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delegatedAdmin":
            return Optional.ofNullable(clazz.cast(delegatedAdmin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDelegatedAdminAccountResponse, T> g) {
        return obj -> g.apply((GetDelegatedAdminAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDelegatedAdminAccountResponse> {
        /**
         * <p>
         * The Amazon Web Services account ID of the Amazon Inspector delegated administrator.
         * </p>
         * 
         * @param delegatedAdmin
         *        The Amazon Web Services account ID of the Amazon Inspector delegated administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedAdmin(DelegatedAdmin delegatedAdmin);

        /**
         * <p>
         * The Amazon Web Services account ID of the Amazon Inspector delegated administrator.
         * </p>
         * This is a convenience method that creates an instance of the {@link DelegatedAdmin.Builder} avoiding the need
         * to create one manually via {@link DelegatedAdmin#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DelegatedAdmin.Builder#build()} is called immediately and its
         * result is passed to {@link #delegatedAdmin(DelegatedAdmin)}.
         * 
         * @param delegatedAdmin
         *        a consumer that will call methods on {@link DelegatedAdmin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegatedAdmin(DelegatedAdmin)
         */
        default Builder delegatedAdmin(Consumer<DelegatedAdmin.Builder> delegatedAdmin) {
            return delegatedAdmin(DelegatedAdmin.builder().applyMutation(delegatedAdmin).build());
        }
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private DelegatedAdmin delegatedAdmin;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDelegatedAdminAccountResponse model) {
            super(model);
            delegatedAdmin(model.delegatedAdmin);
        }

        public final DelegatedAdmin.Builder getDelegatedAdmin() {
            return delegatedAdmin != null ? delegatedAdmin.toBuilder() : null;
        }

        public final void setDelegatedAdmin(DelegatedAdmin.BuilderImpl delegatedAdmin) {
            this.delegatedAdmin = delegatedAdmin != null ? delegatedAdmin.build() : null;
        }

        @Override
        public final Builder delegatedAdmin(DelegatedAdmin delegatedAdmin) {
            this.delegatedAdmin = delegatedAdmin;
            return this;
        }

        @Override
        public GetDelegatedAdminAccountResponse build() {
            return new GetDelegatedAdminAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
