/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information on the Amazon ECR repository metadata associated with a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcrRepositoryMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<EcrRepositoryMetadata.Builder, EcrRepositoryMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EcrRepositoryMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SCAN_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanFrequency").getter(getter(EcrRepositoryMetadata::scanFrequencyAsString))
            .setter(setter(Builder::scanFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanFrequency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SCAN_FREQUENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String scanFrequency;

    private EcrRepositoryMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.scanFrequency = builder.scanFrequency;
    }

    /**
     * <p>
     * The name of the Amazon ECR repository.
     * </p>
     * 
     * @return The name of the Amazon ECR repository.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The frequency of scans.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanFrequency}
     * will return {@link EcrScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanFrequencyAsString}.
     * </p>
     * 
     * @return The frequency of scans.
     * @see EcrScanFrequency
     */
    public final EcrScanFrequency scanFrequency() {
        return EcrScanFrequency.fromValue(scanFrequency);
    }

    /**
     * <p>
     * The frequency of scans.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanFrequency}
     * will return {@link EcrScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanFrequencyAsString}.
     * </p>
     * 
     * @return The frequency of scans.
     * @see EcrScanFrequency
     */
    public final String scanFrequencyAsString() {
        return scanFrequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scanFrequencyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcrRepositoryMetadata)) {
            return false;
        }
        EcrRepositoryMetadata other = (EcrRepositoryMetadata) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scanFrequencyAsString(), other.scanFrequencyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcrRepositoryMetadata").add("Name", name()).add("ScanFrequency", scanFrequencyAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "scanFrequency":
            return Optional.ofNullable(clazz.cast(scanFrequencyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcrRepositoryMetadata, T> g) {
        return obj -> g.apply((EcrRepositoryMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcrRepositoryMetadata> {
        /**
         * <p>
         * The name of the Amazon ECR repository.
         * </p>
         * 
         * @param name
         *        The name of the Amazon ECR repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The frequency of scans.
         * </p>
         * 
         * @param scanFrequency
         *        The frequency of scans.
         * @see EcrScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrScanFrequency
         */
        Builder scanFrequency(String scanFrequency);

        /**
         * <p>
         * The frequency of scans.
         * </p>
         * 
         * @param scanFrequency
         *        The frequency of scans.
         * @see EcrScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrScanFrequency
         */
        Builder scanFrequency(EcrScanFrequency scanFrequency);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String scanFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(EcrRepositoryMetadata model) {
            name(model.name);
            scanFrequency(model.scanFrequency);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScanFrequency() {
            return scanFrequency;
        }

        public final void setScanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
        }

        @Override
        public final Builder scanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
            return this;
        }

        @Override
        public final Builder scanFrequency(EcrScanFrequency scanFrequency) {
            this.scanFrequency(scanFrequency == null ? null : scanFrequency.toString());
            return this;
        }

        @Override
        public EcrRepositoryMetadata build() {
            return new EcrRepositoryMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
