/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the Amazon Inspector delegated administrator for your organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DelegatedAdmin implements SdkPojo, Serializable, ToCopyableBuilder<DelegatedAdmin.Builder, DelegatedAdmin> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(DelegatedAdmin::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> RELATIONSHIP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relationshipStatus").getter(getter(DelegatedAdmin::relationshipStatusAsString))
            .setter(setter(Builder::relationshipStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            RELATIONSHIP_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String relationshipStatus;

    private DelegatedAdmin(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.relationshipStatus = builder.relationshipStatus;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The status of the Amazon Inspector delegated administrator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relationshipStatus} will return {@link RelationshipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #relationshipStatusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Inspector delegated administrator.
     * @see RelationshipStatus
     */
    public final RelationshipStatus relationshipStatus() {
        return RelationshipStatus.fromValue(relationshipStatus);
    }

    /**
     * <p>
     * The status of the Amazon Inspector delegated administrator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relationshipStatus} will return {@link RelationshipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #relationshipStatusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Inspector delegated administrator.
     * @see RelationshipStatus
     */
    public final String relationshipStatusAsString() {
        return relationshipStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegatedAdmin)) {
            return false;
        }
        DelegatedAdmin other = (DelegatedAdmin) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(relationshipStatusAsString(), other.relationshipStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DelegatedAdmin").add("AccountId", accountId())
                .add("RelationshipStatus", relationshipStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "relationshipStatus":
            return Optional.ofNullable(clazz.cast(relationshipStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DelegatedAdmin, T> g) {
        return obj -> g.apply((DelegatedAdmin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DelegatedAdmin> {
        /**
         * <p>
         * The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The status of the Amazon Inspector delegated administrator.
         * </p>
         * 
         * @param relationshipStatus
         *        The status of the Amazon Inspector delegated administrator.
         * @see RelationshipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipStatus
         */
        Builder relationshipStatus(String relationshipStatus);

        /**
         * <p>
         * The status of the Amazon Inspector delegated administrator.
         * </p>
         * 
         * @param relationshipStatus
         *        The status of the Amazon Inspector delegated administrator.
         * @see RelationshipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipStatus
         */
        Builder relationshipStatus(RelationshipStatus relationshipStatus);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String relationshipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegatedAdmin model) {
            accountId(model.accountId);
            relationshipStatus(model.relationshipStatus);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRelationshipStatus() {
            return relationshipStatus;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        @Override
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        @Override
        public final Builder relationshipStatus(RelationshipStatus relationshipStatus) {
            this.relationshipStatus(relationshipStatus == null ? null : relationshipStatus.toString());
            return this;
        }

        @Override
        public DelegatedAdmin build() {
            return new DelegatedAdmin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
