/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.inspector2.DefaultInspector2BaseClientBuilder;
import software.amazon.awssdk.services.inspector2.DefaultInspector2Client;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.Inspector2ClientBuilder;
import software.amazon.awssdk.services.inspector2.Inspector2ServiceClientConfiguration;
import software.amazon.awssdk.services.inspector2.endpoints.Inspector2EndpointProvider;

@SdkInternalApi
final class DefaultInspector2ClientBuilder
extends DefaultInspector2BaseClientBuilder<Inspector2ClientBuilder, Inspector2Client>
implements Inspector2ClientBuilder {
    DefaultInspector2ClientBuilder() {
    }

    @Override
    public DefaultInspector2ClientBuilder endpointProvider(Inspector2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Inspector2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultInspector2ClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        Inspector2ServiceClientConfiguration serviceClientConfiguration = Inspector2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultInspector2Client(serviceClientConfiguration, clientConfiguration);
    }
}

