/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.PackageSortBy;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageAggregation> {
    private static final SdkField<List<StringFilter>> PACKAGE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("packageNames").getter(PackageAggregation.getter(PackageAggregation::packageNames)).setter(PackageAggregation.setter(Builder::packageNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(PackageAggregation.getter(PackageAggregation::sortByAsString)).setter(PackageAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(PackageAggregation.getter(PackageAggregation::sortOrderAsString)).setter(PackageAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAMES_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<StringFilter> packageNames;
    private final String sortBy;
    private final String sortOrder;

    private PackageAggregation(BuilderImpl builder) {
        this.packageNames = builder.packageNames;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final boolean hasPackageNames() {
        return this.packageNames != null && !(this.packageNames instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> packageNames() {
        return this.packageNames;
    }

    public final PackageSortBy sortBy() {
        return PackageSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageNames() ? this.packageNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageAggregation)) {
            return false;
        }
        PackageAggregation other = (PackageAggregation)obj;
        return this.hasPackageNames() == other.hasPackageNames() && Objects.equals(this.packageNames(), other.packageNames()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PackageAggregation").add("PackageNames", this.hasPackageNames() ? this.packageNames() : null).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageNames": {
                return Optional.ofNullable(clazz.cast(this.packageNames()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageAggregation, T> g) {
        return obj -> g.apply((PackageAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringFilter> packageNames = DefaultSdkAutoConstructList.getInstance();
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageAggregation model) {
            this.packageNames(model.packageNames);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getPackageNames() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.packageNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageNames(Collection<StringFilter.BuilderImpl> packageNames) {
            this.packageNames = StringFilterListCopier.copyFromBuilder(packageNames);
        }

        @Override
        public final Builder packageNames(Collection<StringFilter> packageNames) {
            this.packageNames = StringFilterListCopier.copy(packageNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageNames(StringFilter ... packageNames) {
            this.packageNames(Arrays.asList(packageNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageNames(Consumer<StringFilter.Builder> ... packageNames) {
            this.packageNames(Stream.of(packageNames).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(PackageSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public PackageAggregation build() {
            return new PackageAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageAggregation> {
        public Builder packageNames(Collection<StringFilter> var1);

        public Builder packageNames(StringFilter ... var1);

        public Builder packageNames(Consumer<StringFilter.Builder> ... var1);

        public Builder sortBy(String var1);

        public Builder sortBy(PackageSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

