/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.SeverityCounts;
import software.amazon.awssdk.services.inspector2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2InstanceAggregationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2InstanceAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(Ec2InstanceAggregationResponse.getter(Ec2InstanceAggregationResponse::accountId)).setter(Ec2InstanceAggregationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> AMI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ami").getter(Ec2InstanceAggregationResponse.getter(Ec2InstanceAggregationResponse::ami)).setter(Ec2InstanceAggregationResponse.setter(Builder::ami)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ami").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(Ec2InstanceAggregationResponse.getter(Ec2InstanceAggregationResponse::instanceId)).setter(Ec2InstanceAggregationResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<Map<String, String>> INSTANCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("instanceTags").getter(Ec2InstanceAggregationResponse.getter(Ec2InstanceAggregationResponse::instanceTags)).setter(Ec2InstanceAggregationResponse.setter(Builder::instanceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> NETWORK_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("networkFindings").getter(Ec2InstanceAggregationResponse.getter(Ec2InstanceAggregationResponse::networkFindings)).setter(Ec2InstanceAggregationResponse.setter(Builder::networkFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkFindings").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operatingSystem").getter(Ec2InstanceAggregationResponse.getter(Ec2InstanceAggregationResponse::operatingSystem)).setter(Ec2InstanceAggregationResponse.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystem").build()}).build();
    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("severityCounts").getter(Ec2InstanceAggregationResponse.getter(Ec2InstanceAggregationResponse::severityCounts)).setter(Ec2InstanceAggregationResponse.setter(Builder::severityCounts)).constructor(SeverityCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, AMI_FIELD, INSTANCE_ID_FIELD, INSTANCE_TAGS_FIELD, NETWORK_FINDINGS_FIELD, OPERATING_SYSTEM_FIELD, SEVERITY_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String ami;
    private final String instanceId;
    private final Map<String, String> instanceTags;
    private final Long networkFindings;
    private final String operatingSystem;
    private final SeverityCounts severityCounts;

    private Ec2InstanceAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.ami = builder.ami;
        this.instanceId = builder.instanceId;
        this.instanceTags = builder.instanceTags;
        this.networkFindings = builder.networkFindings;
        this.operatingSystem = builder.operatingSystem;
        this.severityCounts = builder.severityCounts;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String ami() {
        return this.ami;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasInstanceTags() {
        return this.instanceTags != null && !(this.instanceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> instanceTags() {
        return this.instanceTags;
    }

    public final Long networkFindings() {
        return this.networkFindings;
    }

    public final String operatingSystem() {
        return this.operatingSystem;
    }

    public final SeverityCounts severityCounts() {
        return this.severityCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ami());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTags() ? this.instanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceAggregationResponse)) {
            return false;
        }
        Ec2InstanceAggregationResponse other = (Ec2InstanceAggregationResponse)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.ami(), other.ami()) && Objects.equals(this.instanceId(), other.instanceId()) && this.hasInstanceTags() == other.hasInstanceTags() && Objects.equals(this.instanceTags(), other.instanceTags()) && Objects.equals(this.networkFindings(), other.networkFindings()) && Objects.equals(this.operatingSystem(), other.operatingSystem()) && Objects.equals(this.severityCounts(), other.severityCounts());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2InstanceAggregationResponse").add("AccountId", (Object)this.accountId()).add("Ami", (Object)this.ami()).add("InstanceId", (Object)this.instanceId()).add("InstanceTags", this.hasInstanceTags() ? this.instanceTags() : null).add("NetworkFindings", (Object)this.networkFindings()).add("OperatingSystem", (Object)this.operatingSystem()).add("SeverityCounts", (Object)this.severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ami": {
                return Optional.ofNullable(clazz.cast(this.ami()));
            }
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "instanceTags": {
                return Optional.ofNullable(clazz.cast(this.instanceTags()));
            }
            case "networkFindings": {
                return Optional.ofNullable(clazz.cast(this.networkFindings()));
            }
            case "operatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystem()));
            }
            case "severityCounts": {
                return Optional.ofNullable(clazz.cast(this.severityCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2InstanceAggregationResponse, T> g) {
        return obj -> g.apply((Ec2InstanceAggregationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String ami;
        private String instanceId;
        private Map<String, String> instanceTags = DefaultSdkAutoConstructMap.getInstance();
        private Long networkFindings;
        private String operatingSystem;
        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceAggregationResponse model) {
            this.accountId(model.accountId);
            this.ami(model.ami);
            this.instanceId(model.instanceId);
            this.instanceTags(model.instanceTags);
            this.networkFindings(model.networkFindings);
            this.operatingSystem(model.operatingSystem);
            this.severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAmi() {
            return this.ami;
        }

        public final void setAmi(String ami) {
            this.ami = ami;
        }

        @Override
        public final Builder ami(String ami) {
            this.ami = ami;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, String> getInstanceTags() {
            if (this.instanceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.instanceTags;
        }

        public final void setInstanceTags(Map<String, String> instanceTags) {
            this.instanceTags = TagMapCopier.copy(instanceTags);
        }

        @Override
        public final Builder instanceTags(Map<String, String> instanceTags) {
            this.instanceTags = TagMapCopier.copy(instanceTags);
            return this;
        }

        public final Long getNetworkFindings() {
            return this.networkFindings;
        }

        public final void setNetworkFindings(Long networkFindings) {
            this.networkFindings = networkFindings;
        }

        @Override
        public final Builder networkFindings(Long networkFindings) {
            this.networkFindings = networkFindings;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return this.severityCounts != null ? this.severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public Ec2InstanceAggregationResponse build() {
            return new Ec2InstanceAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2InstanceAggregationResponse> {
        public Builder accountId(String var1);

        public Builder ami(String var1);

        public Builder instanceId(String var1);

        public Builder instanceTags(Map<String, String> var1);

        public Builder networkFindings(Long var1);

        public Builder operatingSystem(String var1);

        public Builder severityCounts(SeverityCounts var1);

        default public Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return this.severityCounts((SeverityCounts)((SeverityCounts.Builder)SeverityCounts.builder().applyMutation(severityCounts)).build());
        }
    }
}

