/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.AccountAggregation;
import software.amazon.awssdk.services.inspector2.model.AmiAggregation;
import software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregation;
import software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregation;
import software.amazon.awssdk.services.inspector2.model.FindingTypeAggregation;
import software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation;
import software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregation;
import software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregation;
import software.amazon.awssdk.services.inspector2.model.PackageAggregation;
import software.amazon.awssdk.services.inspector2.model.RepositoryAggregation;
import software.amazon.awssdk.services.inspector2.model.TitleAggregation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationRequest> {
    private static final SdkField<AccountAggregation> ACCOUNT_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accountAggregation").getter(AggregationRequest.getter(AggregationRequest::accountAggregation)).setter(AggregationRequest.setter(Builder::accountAggregation)).constructor(AccountAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAggregation").build()}).build();
    private static final SdkField<AmiAggregation> AMI_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("amiAggregation").getter(AggregationRequest.getter(AggregationRequest::amiAggregation)).setter(AggregationRequest.setter(Builder::amiAggregation)).constructor(AmiAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiAggregation").build()}).build();
    private static final SdkField<AwsEcrContainerAggregation> AWS_ECR_CONTAINER_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsEcrContainerAggregation").getter(AggregationRequest.getter(AggregationRequest::awsEcrContainerAggregation)).setter(AggregationRequest.setter(Builder::awsEcrContainerAggregation)).constructor(AwsEcrContainerAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEcrContainerAggregation").build()}).build();
    private static final SdkField<Ec2InstanceAggregation> EC2_INSTANCE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2InstanceAggregation").getter(AggregationRequest.getter(AggregationRequest::ec2InstanceAggregation)).setter(AggregationRequest.setter(Builder::ec2InstanceAggregation)).constructor(Ec2InstanceAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceAggregation").build()}).build();
    private static final SdkField<FindingTypeAggregation> FINDING_TYPE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("findingTypeAggregation").getter(AggregationRequest.getter(AggregationRequest::findingTypeAggregation)).setter(AggregationRequest.setter(Builder::findingTypeAggregation)).constructor(FindingTypeAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingTypeAggregation").build()}).build();
    private static final SdkField<ImageLayerAggregation> IMAGE_LAYER_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageLayerAggregation").getter(AggregationRequest.getter(AggregationRequest::imageLayerAggregation)).setter(AggregationRequest.setter(Builder::imageLayerAggregation)).constructor(ImageLayerAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageLayerAggregation").build()}).build();
    private static final SdkField<LambdaFunctionAggregation> LAMBDA_FUNCTION_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaFunctionAggregation").getter(AggregationRequest.getter(AggregationRequest::lambdaFunctionAggregation)).setter(AggregationRequest.setter(Builder::lambdaFunctionAggregation)).constructor(LambdaFunctionAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionAggregation").build()}).build();
    private static final SdkField<LambdaLayerAggregation> LAMBDA_LAYER_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaLayerAggregation").getter(AggregationRequest.getter(AggregationRequest::lambdaLayerAggregation)).setter(AggregationRequest.setter(Builder::lambdaLayerAggregation)).constructor(LambdaLayerAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaLayerAggregation").build()}).build();
    private static final SdkField<PackageAggregation> PACKAGE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageAggregation").getter(AggregationRequest.getter(AggregationRequest::packageAggregation)).setter(AggregationRequest.setter(Builder::packageAggregation)).constructor(PackageAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageAggregation").build()}).build();
    private static final SdkField<RepositoryAggregation> REPOSITORY_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("repositoryAggregation").getter(AggregationRequest.getter(AggregationRequest::repositoryAggregation)).setter(AggregationRequest.setter(Builder::repositoryAggregation)).constructor(RepositoryAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryAggregation").build()}).build();
    private static final SdkField<TitleAggregation> TITLE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("titleAggregation").getter(AggregationRequest.getter(AggregationRequest::titleAggregation)).setter(AggregationRequest.setter(Builder::titleAggregation)).constructor(TitleAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titleAggregation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_AGGREGATION_FIELD, AMI_AGGREGATION_FIELD, AWS_ECR_CONTAINER_AGGREGATION_FIELD, EC2_INSTANCE_AGGREGATION_FIELD, FINDING_TYPE_AGGREGATION_FIELD, IMAGE_LAYER_AGGREGATION_FIELD, LAMBDA_FUNCTION_AGGREGATION_FIELD, LAMBDA_LAYER_AGGREGATION_FIELD, PACKAGE_AGGREGATION_FIELD, REPOSITORY_AGGREGATION_FIELD, TITLE_AGGREGATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccountAggregation accountAggregation;
    private final AmiAggregation amiAggregation;
    private final AwsEcrContainerAggregation awsEcrContainerAggregation;
    private final Ec2InstanceAggregation ec2InstanceAggregation;
    private final FindingTypeAggregation findingTypeAggregation;
    private final ImageLayerAggregation imageLayerAggregation;
    private final LambdaFunctionAggregation lambdaFunctionAggregation;
    private final LambdaLayerAggregation lambdaLayerAggregation;
    private final PackageAggregation packageAggregation;
    private final RepositoryAggregation repositoryAggregation;
    private final TitleAggregation titleAggregation;
    private final Type type;

    private AggregationRequest(BuilderImpl builder) {
        this.accountAggregation = builder.accountAggregation;
        this.amiAggregation = builder.amiAggregation;
        this.awsEcrContainerAggregation = builder.awsEcrContainerAggregation;
        this.ec2InstanceAggregation = builder.ec2InstanceAggregation;
        this.findingTypeAggregation = builder.findingTypeAggregation;
        this.imageLayerAggregation = builder.imageLayerAggregation;
        this.lambdaFunctionAggregation = builder.lambdaFunctionAggregation;
        this.lambdaLayerAggregation = builder.lambdaLayerAggregation;
        this.packageAggregation = builder.packageAggregation;
        this.repositoryAggregation = builder.repositoryAggregation;
        this.titleAggregation = builder.titleAggregation;
        this.type = builder.type;
    }

    public final AccountAggregation accountAggregation() {
        return this.accountAggregation;
    }

    public final AmiAggregation amiAggregation() {
        return this.amiAggregation;
    }

    public final AwsEcrContainerAggregation awsEcrContainerAggregation() {
        return this.awsEcrContainerAggregation;
    }

    public final Ec2InstanceAggregation ec2InstanceAggregation() {
        return this.ec2InstanceAggregation;
    }

    public final FindingTypeAggregation findingTypeAggregation() {
        return this.findingTypeAggregation;
    }

    public final ImageLayerAggregation imageLayerAggregation() {
        return this.imageLayerAggregation;
    }

    public final LambdaFunctionAggregation lambdaFunctionAggregation() {
        return this.lambdaFunctionAggregation;
    }

    public final LambdaLayerAggregation lambdaLayerAggregation() {
        return this.lambdaLayerAggregation;
    }

    public final PackageAggregation packageAggregation() {
        return this.packageAggregation;
    }

    public final RepositoryAggregation repositoryAggregation() {
        return this.repositoryAggregation;
    }

    public final TitleAggregation titleAggregation() {
        return this.titleAggregation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEcrContainerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingTypeAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageLayerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaLayerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.titleAggregation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationRequest)) {
            return false;
        }
        AggregationRequest other = (AggregationRequest)obj;
        return Objects.equals(this.accountAggregation(), other.accountAggregation()) && Objects.equals(this.amiAggregation(), other.amiAggregation()) && Objects.equals(this.awsEcrContainerAggregation(), other.awsEcrContainerAggregation()) && Objects.equals(this.ec2InstanceAggregation(), other.ec2InstanceAggregation()) && Objects.equals(this.findingTypeAggregation(), other.findingTypeAggregation()) && Objects.equals(this.imageLayerAggregation(), other.imageLayerAggregation()) && Objects.equals(this.lambdaFunctionAggregation(), other.lambdaFunctionAggregation()) && Objects.equals(this.lambdaLayerAggregation(), other.lambdaLayerAggregation()) && Objects.equals(this.packageAggregation(), other.packageAggregation()) && Objects.equals(this.repositoryAggregation(), other.repositoryAggregation()) && Objects.equals(this.titleAggregation(), other.titleAggregation());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationRequest").add("AccountAggregation", (Object)this.accountAggregation()).add("AmiAggregation", (Object)this.amiAggregation()).add("AwsEcrContainerAggregation", (Object)this.awsEcrContainerAggregation()).add("Ec2InstanceAggregation", (Object)this.ec2InstanceAggregation()).add("FindingTypeAggregation", (Object)this.findingTypeAggregation()).add("ImageLayerAggregation", (Object)this.imageLayerAggregation()).add("LambdaFunctionAggregation", (Object)this.lambdaFunctionAggregation()).add("LambdaLayerAggregation", (Object)this.lambdaLayerAggregation()).add("PackageAggregation", (Object)this.packageAggregation()).add("RepositoryAggregation", (Object)this.repositoryAggregation()).add("TitleAggregation", (Object)this.titleAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountAggregation": {
                return Optional.ofNullable(clazz.cast(this.accountAggregation()));
            }
            case "amiAggregation": {
                return Optional.ofNullable(clazz.cast(this.amiAggregation()));
            }
            case "awsEcrContainerAggregation": {
                return Optional.ofNullable(clazz.cast(this.awsEcrContainerAggregation()));
            }
            case "ec2InstanceAggregation": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceAggregation()));
            }
            case "findingTypeAggregation": {
                return Optional.ofNullable(clazz.cast(this.findingTypeAggregation()));
            }
            case "imageLayerAggregation": {
                return Optional.ofNullable(clazz.cast(this.imageLayerAggregation()));
            }
            case "lambdaFunctionAggregation": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionAggregation()));
            }
            case "lambdaLayerAggregation": {
                return Optional.ofNullable(clazz.cast(this.lambdaLayerAggregation()));
            }
            case "packageAggregation": {
                return Optional.ofNullable(clazz.cast(this.packageAggregation()));
            }
            case "repositoryAggregation": {
                return Optional.ofNullable(clazz.cast(this.repositoryAggregation()));
            }
            case "titleAggregation": {
                return Optional.ofNullable(clazz.cast(this.titleAggregation()));
            }
        }
        return Optional.empty();
    }

    public static AggregationRequest fromAccountAggregation(AccountAggregation accountAggregation) {
        return (AggregationRequest)AggregationRequest.builder().accountAggregation(accountAggregation).build();
    }

    public static AggregationRequest fromAccountAggregation(Consumer<AccountAggregation.Builder> accountAggregation) {
        AccountAggregation.Builder builder = AccountAggregation.builder();
        accountAggregation.accept(builder);
        return AggregationRequest.fromAccountAggregation((AccountAggregation)builder.build());
    }

    public static AggregationRequest fromAmiAggregation(AmiAggregation amiAggregation) {
        return (AggregationRequest)AggregationRequest.builder().amiAggregation(amiAggregation).build();
    }

    public static AggregationRequest fromAmiAggregation(Consumer<AmiAggregation.Builder> amiAggregation) {
        AmiAggregation.Builder builder = AmiAggregation.builder();
        amiAggregation.accept(builder);
        return AggregationRequest.fromAmiAggregation((AmiAggregation)builder.build());
    }

    public static AggregationRequest fromAwsEcrContainerAggregation(AwsEcrContainerAggregation awsEcrContainerAggregation) {
        return (AggregationRequest)AggregationRequest.builder().awsEcrContainerAggregation(awsEcrContainerAggregation).build();
    }

    public static AggregationRequest fromAwsEcrContainerAggregation(Consumer<AwsEcrContainerAggregation.Builder> awsEcrContainerAggregation) {
        AwsEcrContainerAggregation.Builder builder = AwsEcrContainerAggregation.builder();
        awsEcrContainerAggregation.accept(builder);
        return AggregationRequest.fromAwsEcrContainerAggregation((AwsEcrContainerAggregation)builder.build());
    }

    public static AggregationRequest fromEc2InstanceAggregation(Ec2InstanceAggregation ec2InstanceAggregation) {
        return (AggregationRequest)AggregationRequest.builder().ec2InstanceAggregation(ec2InstanceAggregation).build();
    }

    public static AggregationRequest fromEc2InstanceAggregation(Consumer<Ec2InstanceAggregation.Builder> ec2InstanceAggregation) {
        Ec2InstanceAggregation.Builder builder = Ec2InstanceAggregation.builder();
        ec2InstanceAggregation.accept(builder);
        return AggregationRequest.fromEc2InstanceAggregation((Ec2InstanceAggregation)builder.build());
    }

    public static AggregationRequest fromFindingTypeAggregation(FindingTypeAggregation findingTypeAggregation) {
        return (AggregationRequest)AggregationRequest.builder().findingTypeAggregation(findingTypeAggregation).build();
    }

    public static AggregationRequest fromFindingTypeAggregation(Consumer<FindingTypeAggregation.Builder> findingTypeAggregation) {
        FindingTypeAggregation.Builder builder = FindingTypeAggregation.builder();
        findingTypeAggregation.accept(builder);
        return AggregationRequest.fromFindingTypeAggregation((FindingTypeAggregation)builder.build());
    }

    public static AggregationRequest fromImageLayerAggregation(ImageLayerAggregation imageLayerAggregation) {
        return (AggregationRequest)AggregationRequest.builder().imageLayerAggregation(imageLayerAggregation).build();
    }

    public static AggregationRequest fromImageLayerAggregation(Consumer<ImageLayerAggregation.Builder> imageLayerAggregation) {
        ImageLayerAggregation.Builder builder = ImageLayerAggregation.builder();
        imageLayerAggregation.accept(builder);
        return AggregationRequest.fromImageLayerAggregation((ImageLayerAggregation)builder.build());
    }

    public static AggregationRequest fromLambdaFunctionAggregation(LambdaFunctionAggregation lambdaFunctionAggregation) {
        return (AggregationRequest)AggregationRequest.builder().lambdaFunctionAggregation(lambdaFunctionAggregation).build();
    }

    public static AggregationRequest fromLambdaFunctionAggregation(Consumer<LambdaFunctionAggregation.Builder> lambdaFunctionAggregation) {
        LambdaFunctionAggregation.Builder builder = LambdaFunctionAggregation.builder();
        lambdaFunctionAggregation.accept(builder);
        return AggregationRequest.fromLambdaFunctionAggregation((LambdaFunctionAggregation)builder.build());
    }

    public static AggregationRequest fromLambdaLayerAggregation(LambdaLayerAggregation lambdaLayerAggregation) {
        return (AggregationRequest)AggregationRequest.builder().lambdaLayerAggregation(lambdaLayerAggregation).build();
    }

    public static AggregationRequest fromLambdaLayerAggregation(Consumer<LambdaLayerAggregation.Builder> lambdaLayerAggregation) {
        LambdaLayerAggregation.Builder builder = LambdaLayerAggregation.builder();
        lambdaLayerAggregation.accept(builder);
        return AggregationRequest.fromLambdaLayerAggregation((LambdaLayerAggregation)builder.build());
    }

    public static AggregationRequest fromPackageAggregation(PackageAggregation packageAggregation) {
        return (AggregationRequest)AggregationRequest.builder().packageAggregation(packageAggregation).build();
    }

    public static AggregationRequest fromPackageAggregation(Consumer<PackageAggregation.Builder> packageAggregation) {
        PackageAggregation.Builder builder = PackageAggregation.builder();
        packageAggregation.accept(builder);
        return AggregationRequest.fromPackageAggregation((PackageAggregation)builder.build());
    }

    public static AggregationRequest fromRepositoryAggregation(RepositoryAggregation repositoryAggregation) {
        return (AggregationRequest)AggregationRequest.builder().repositoryAggregation(repositoryAggregation).build();
    }

    public static AggregationRequest fromRepositoryAggregation(Consumer<RepositoryAggregation.Builder> repositoryAggregation) {
        RepositoryAggregation.Builder builder = RepositoryAggregation.builder();
        repositoryAggregation.accept(builder);
        return AggregationRequest.fromRepositoryAggregation((RepositoryAggregation)builder.build());
    }

    public static AggregationRequest fromTitleAggregation(TitleAggregation titleAggregation) {
        return (AggregationRequest)AggregationRequest.builder().titleAggregation(titleAggregation).build();
    }

    public static AggregationRequest fromTitleAggregation(Consumer<TitleAggregation.Builder> titleAggregation) {
        TitleAggregation.Builder builder = TitleAggregation.builder();
        titleAggregation.accept(builder);
        return AggregationRequest.fromTitleAggregation((TitleAggregation)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationRequest, T> g) {
        return obj -> g.apply((AggregationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ACCOUNT_AGGREGATION,
        AMI_AGGREGATION,
        AWS_ECR_CONTAINER_AGGREGATION,
        EC2_INSTANCE_AGGREGATION,
        FINDING_TYPE_AGGREGATION,
        IMAGE_LAYER_AGGREGATION,
        LAMBDA_FUNCTION_AGGREGATION,
        LAMBDA_LAYER_AGGREGATION,
        PACKAGE_AGGREGATION,
        REPOSITORY_AGGREGATION,
        TITLE_AGGREGATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AccountAggregation accountAggregation;
        private AmiAggregation amiAggregation;
        private AwsEcrContainerAggregation awsEcrContainerAggregation;
        private Ec2InstanceAggregation ec2InstanceAggregation;
        private FindingTypeAggregation findingTypeAggregation;
        private ImageLayerAggregation imageLayerAggregation;
        private LambdaFunctionAggregation lambdaFunctionAggregation;
        private LambdaLayerAggregation lambdaLayerAggregation;
        private PackageAggregation packageAggregation;
        private RepositoryAggregation repositoryAggregation;
        private TitleAggregation titleAggregation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationRequest model) {
            this.accountAggregation(model.accountAggregation);
            this.amiAggregation(model.amiAggregation);
            this.awsEcrContainerAggregation(model.awsEcrContainerAggregation);
            this.ec2InstanceAggregation(model.ec2InstanceAggregation);
            this.findingTypeAggregation(model.findingTypeAggregation);
            this.imageLayerAggregation(model.imageLayerAggregation);
            this.lambdaFunctionAggregation(model.lambdaFunctionAggregation);
            this.lambdaLayerAggregation(model.lambdaLayerAggregation);
            this.packageAggregation(model.packageAggregation);
            this.repositoryAggregation(model.repositoryAggregation);
            this.titleAggregation(model.titleAggregation);
        }

        public final AccountAggregation.Builder getAccountAggregation() {
            return this.accountAggregation != null ? this.accountAggregation.toBuilder() : null;
        }

        public final void setAccountAggregation(AccountAggregation.BuilderImpl accountAggregation) {
            AccountAggregation oldValue = this.accountAggregation;
            this.accountAggregation = accountAggregation != null ? accountAggregation.build() : null;
            this.handleUnionValueChange(Type.ACCOUNT_AGGREGATION, oldValue, this.accountAggregation);
        }

        @Override
        public final Builder accountAggregation(AccountAggregation accountAggregation) {
            AccountAggregation oldValue = this.accountAggregation;
            this.accountAggregation = accountAggregation;
            this.handleUnionValueChange(Type.ACCOUNT_AGGREGATION, oldValue, this.accountAggregation);
            return this;
        }

        public final AmiAggregation.Builder getAmiAggregation() {
            return this.amiAggregation != null ? this.amiAggregation.toBuilder() : null;
        }

        public final void setAmiAggregation(AmiAggregation.BuilderImpl amiAggregation) {
            AmiAggregation oldValue = this.amiAggregation;
            this.amiAggregation = amiAggregation != null ? amiAggregation.build() : null;
            this.handleUnionValueChange(Type.AMI_AGGREGATION, oldValue, this.amiAggregation);
        }

        @Override
        public final Builder amiAggregation(AmiAggregation amiAggregation) {
            AmiAggregation oldValue = this.amiAggregation;
            this.amiAggregation = amiAggregation;
            this.handleUnionValueChange(Type.AMI_AGGREGATION, oldValue, this.amiAggregation);
            return this;
        }

        public final AwsEcrContainerAggregation.Builder getAwsEcrContainerAggregation() {
            return this.awsEcrContainerAggregation != null ? this.awsEcrContainerAggregation.toBuilder() : null;
        }

        public final void setAwsEcrContainerAggregation(AwsEcrContainerAggregation.BuilderImpl awsEcrContainerAggregation) {
            AwsEcrContainerAggregation oldValue = this.awsEcrContainerAggregation;
            this.awsEcrContainerAggregation = awsEcrContainerAggregation != null ? awsEcrContainerAggregation.build() : null;
            this.handleUnionValueChange(Type.AWS_ECR_CONTAINER_AGGREGATION, oldValue, this.awsEcrContainerAggregation);
        }

        @Override
        public final Builder awsEcrContainerAggregation(AwsEcrContainerAggregation awsEcrContainerAggregation) {
            AwsEcrContainerAggregation oldValue = this.awsEcrContainerAggregation;
            this.awsEcrContainerAggregation = awsEcrContainerAggregation;
            this.handleUnionValueChange(Type.AWS_ECR_CONTAINER_AGGREGATION, oldValue, this.awsEcrContainerAggregation);
            return this;
        }

        public final Ec2InstanceAggregation.Builder getEc2InstanceAggregation() {
            return this.ec2InstanceAggregation != null ? this.ec2InstanceAggregation.toBuilder() : null;
        }

        public final void setEc2InstanceAggregation(Ec2InstanceAggregation.BuilderImpl ec2InstanceAggregation) {
            Ec2InstanceAggregation oldValue = this.ec2InstanceAggregation;
            this.ec2InstanceAggregation = ec2InstanceAggregation != null ? ec2InstanceAggregation.build() : null;
            this.handleUnionValueChange(Type.EC2_INSTANCE_AGGREGATION, oldValue, this.ec2InstanceAggregation);
        }

        @Override
        public final Builder ec2InstanceAggregation(Ec2InstanceAggregation ec2InstanceAggregation) {
            Ec2InstanceAggregation oldValue = this.ec2InstanceAggregation;
            this.ec2InstanceAggregation = ec2InstanceAggregation;
            this.handleUnionValueChange(Type.EC2_INSTANCE_AGGREGATION, oldValue, this.ec2InstanceAggregation);
            return this;
        }

        public final FindingTypeAggregation.Builder getFindingTypeAggregation() {
            return this.findingTypeAggregation != null ? this.findingTypeAggregation.toBuilder() : null;
        }

        public final void setFindingTypeAggregation(FindingTypeAggregation.BuilderImpl findingTypeAggregation) {
            FindingTypeAggregation oldValue = this.findingTypeAggregation;
            this.findingTypeAggregation = findingTypeAggregation != null ? findingTypeAggregation.build() : null;
            this.handleUnionValueChange(Type.FINDING_TYPE_AGGREGATION, oldValue, this.findingTypeAggregation);
        }

        @Override
        public final Builder findingTypeAggregation(FindingTypeAggregation findingTypeAggregation) {
            FindingTypeAggregation oldValue = this.findingTypeAggregation;
            this.findingTypeAggregation = findingTypeAggregation;
            this.handleUnionValueChange(Type.FINDING_TYPE_AGGREGATION, oldValue, this.findingTypeAggregation);
            return this;
        }

        public final ImageLayerAggregation.Builder getImageLayerAggregation() {
            return this.imageLayerAggregation != null ? this.imageLayerAggregation.toBuilder() : null;
        }

        public final void setImageLayerAggregation(ImageLayerAggregation.BuilderImpl imageLayerAggregation) {
            ImageLayerAggregation oldValue = this.imageLayerAggregation;
            this.imageLayerAggregation = imageLayerAggregation != null ? imageLayerAggregation.build() : null;
            this.handleUnionValueChange(Type.IMAGE_LAYER_AGGREGATION, oldValue, this.imageLayerAggregation);
        }

        @Override
        public final Builder imageLayerAggregation(ImageLayerAggregation imageLayerAggregation) {
            ImageLayerAggregation oldValue = this.imageLayerAggregation;
            this.imageLayerAggregation = imageLayerAggregation;
            this.handleUnionValueChange(Type.IMAGE_LAYER_AGGREGATION, oldValue, this.imageLayerAggregation);
            return this;
        }

        public final LambdaFunctionAggregation.Builder getLambdaFunctionAggregation() {
            return this.lambdaFunctionAggregation != null ? this.lambdaFunctionAggregation.toBuilder() : null;
        }

        public final void setLambdaFunctionAggregation(LambdaFunctionAggregation.BuilderImpl lambdaFunctionAggregation) {
            LambdaFunctionAggregation oldValue = this.lambdaFunctionAggregation;
            this.lambdaFunctionAggregation = lambdaFunctionAggregation != null ? lambdaFunctionAggregation.build() : null;
            this.handleUnionValueChange(Type.LAMBDA_FUNCTION_AGGREGATION, oldValue, this.lambdaFunctionAggregation);
        }

        @Override
        public final Builder lambdaFunctionAggregation(LambdaFunctionAggregation lambdaFunctionAggregation) {
            LambdaFunctionAggregation oldValue = this.lambdaFunctionAggregation;
            this.lambdaFunctionAggregation = lambdaFunctionAggregation;
            this.handleUnionValueChange(Type.LAMBDA_FUNCTION_AGGREGATION, oldValue, this.lambdaFunctionAggregation);
            return this;
        }

        public final LambdaLayerAggregation.Builder getLambdaLayerAggregation() {
            return this.lambdaLayerAggregation != null ? this.lambdaLayerAggregation.toBuilder() : null;
        }

        public final void setLambdaLayerAggregation(LambdaLayerAggregation.BuilderImpl lambdaLayerAggregation) {
            LambdaLayerAggregation oldValue = this.lambdaLayerAggregation;
            this.lambdaLayerAggregation = lambdaLayerAggregation != null ? lambdaLayerAggregation.build() : null;
            this.handleUnionValueChange(Type.LAMBDA_LAYER_AGGREGATION, oldValue, this.lambdaLayerAggregation);
        }

        @Override
        public final Builder lambdaLayerAggregation(LambdaLayerAggregation lambdaLayerAggregation) {
            LambdaLayerAggregation oldValue = this.lambdaLayerAggregation;
            this.lambdaLayerAggregation = lambdaLayerAggregation;
            this.handleUnionValueChange(Type.LAMBDA_LAYER_AGGREGATION, oldValue, this.lambdaLayerAggregation);
            return this;
        }

        public final PackageAggregation.Builder getPackageAggregation() {
            return this.packageAggregation != null ? this.packageAggregation.toBuilder() : null;
        }

        public final void setPackageAggregation(PackageAggregation.BuilderImpl packageAggregation) {
            PackageAggregation oldValue = this.packageAggregation;
            this.packageAggregation = packageAggregation != null ? packageAggregation.build() : null;
            this.handleUnionValueChange(Type.PACKAGE_AGGREGATION, oldValue, this.packageAggregation);
        }

        @Override
        public final Builder packageAggregation(PackageAggregation packageAggregation) {
            PackageAggregation oldValue = this.packageAggregation;
            this.packageAggregation = packageAggregation;
            this.handleUnionValueChange(Type.PACKAGE_AGGREGATION, oldValue, this.packageAggregation);
            return this;
        }

        public final RepositoryAggregation.Builder getRepositoryAggregation() {
            return this.repositoryAggregation != null ? this.repositoryAggregation.toBuilder() : null;
        }

        public final void setRepositoryAggregation(RepositoryAggregation.BuilderImpl repositoryAggregation) {
            RepositoryAggregation oldValue = this.repositoryAggregation;
            this.repositoryAggregation = repositoryAggregation != null ? repositoryAggregation.build() : null;
            this.handleUnionValueChange(Type.REPOSITORY_AGGREGATION, oldValue, this.repositoryAggregation);
        }

        @Override
        public final Builder repositoryAggregation(RepositoryAggregation repositoryAggregation) {
            RepositoryAggregation oldValue = this.repositoryAggregation;
            this.repositoryAggregation = repositoryAggregation;
            this.handleUnionValueChange(Type.REPOSITORY_AGGREGATION, oldValue, this.repositoryAggregation);
            return this;
        }

        public final TitleAggregation.Builder getTitleAggregation() {
            return this.titleAggregation != null ? this.titleAggregation.toBuilder() : null;
        }

        public final void setTitleAggregation(TitleAggregation.BuilderImpl titleAggregation) {
            TitleAggregation oldValue = this.titleAggregation;
            this.titleAggregation = titleAggregation != null ? titleAggregation.build() : null;
            this.handleUnionValueChange(Type.TITLE_AGGREGATION, oldValue, this.titleAggregation);
        }

        @Override
        public final Builder titleAggregation(TitleAggregation titleAggregation) {
            TitleAggregation oldValue = this.titleAggregation;
            this.titleAggregation = titleAggregation;
            this.handleUnionValueChange(Type.TITLE_AGGREGATION, oldValue, this.titleAggregation);
            return this;
        }

        public AggregationRequest build() {
            return new AggregationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationRequest> {
        public Builder accountAggregation(AccountAggregation var1);

        default public Builder accountAggregation(Consumer<AccountAggregation.Builder> accountAggregation) {
            return this.accountAggregation((AccountAggregation)((AccountAggregation.Builder)AccountAggregation.builder().applyMutation(accountAggregation)).build());
        }

        public Builder amiAggregation(AmiAggregation var1);

        default public Builder amiAggregation(Consumer<AmiAggregation.Builder> amiAggregation) {
            return this.amiAggregation((AmiAggregation)((AmiAggregation.Builder)AmiAggregation.builder().applyMutation(amiAggregation)).build());
        }

        public Builder awsEcrContainerAggregation(AwsEcrContainerAggregation var1);

        default public Builder awsEcrContainerAggregation(Consumer<AwsEcrContainerAggregation.Builder> awsEcrContainerAggregation) {
            return this.awsEcrContainerAggregation((AwsEcrContainerAggregation)((AwsEcrContainerAggregation.Builder)AwsEcrContainerAggregation.builder().applyMutation(awsEcrContainerAggregation)).build());
        }

        public Builder ec2InstanceAggregation(Ec2InstanceAggregation var1);

        default public Builder ec2InstanceAggregation(Consumer<Ec2InstanceAggregation.Builder> ec2InstanceAggregation) {
            return this.ec2InstanceAggregation((Ec2InstanceAggregation)((Ec2InstanceAggregation.Builder)Ec2InstanceAggregation.builder().applyMutation(ec2InstanceAggregation)).build());
        }

        public Builder findingTypeAggregation(FindingTypeAggregation var1);

        default public Builder findingTypeAggregation(Consumer<FindingTypeAggregation.Builder> findingTypeAggregation) {
            return this.findingTypeAggregation((FindingTypeAggregation)((FindingTypeAggregation.Builder)FindingTypeAggregation.builder().applyMutation(findingTypeAggregation)).build());
        }

        public Builder imageLayerAggregation(ImageLayerAggregation var1);

        default public Builder imageLayerAggregation(Consumer<ImageLayerAggregation.Builder> imageLayerAggregation) {
            return this.imageLayerAggregation((ImageLayerAggregation)((ImageLayerAggregation.Builder)ImageLayerAggregation.builder().applyMutation(imageLayerAggregation)).build());
        }

        public Builder lambdaFunctionAggregation(LambdaFunctionAggregation var1);

        default public Builder lambdaFunctionAggregation(Consumer<LambdaFunctionAggregation.Builder> lambdaFunctionAggregation) {
            return this.lambdaFunctionAggregation((LambdaFunctionAggregation)((LambdaFunctionAggregation.Builder)LambdaFunctionAggregation.builder().applyMutation(lambdaFunctionAggregation)).build());
        }

        public Builder lambdaLayerAggregation(LambdaLayerAggregation var1);

        default public Builder lambdaLayerAggregation(Consumer<LambdaLayerAggregation.Builder> lambdaLayerAggregation) {
            return this.lambdaLayerAggregation((LambdaLayerAggregation)((LambdaLayerAggregation.Builder)LambdaLayerAggregation.builder().applyMutation(lambdaLayerAggregation)).build());
        }

        public Builder packageAggregation(PackageAggregation var1);

        default public Builder packageAggregation(Consumer<PackageAggregation.Builder> packageAggregation) {
            return this.packageAggregation((PackageAggregation)((PackageAggregation.Builder)PackageAggregation.builder().applyMutation(packageAggregation)).build());
        }

        public Builder repositoryAggregation(RepositoryAggregation var1);

        default public Builder repositoryAggregation(Consumer<RepositoryAggregation.Builder> repositoryAggregation) {
            return this.repositoryAggregation((RepositoryAggregation)((RepositoryAggregation.Builder)RepositoryAggregation.builder().applyMutation(repositoryAggregation)).build());
        }

        public Builder titleAggregation(TitleAggregation var1);

        default public Builder titleAggregation(Consumer<TitleAggregation.Builder> titleAggregation) {
            return this.titleAggregation((TitleAggregation)((TitleAggregation.Builder)TitleAggregation.builder().applyMutation(titleAggregation)).build());
        }
    }
}

