/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.model.AggregationResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse;

public class ListFindingAggregationsIterable
implements SdkIterable<ListFindingAggregationsResponse> {
    private final Inspector2Client client;
    private final ListFindingAggregationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingAggregationsIterable(Inspector2Client client, ListFindingAggregationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFindingAggregationsResponseFetcher();
    }

    public Iterator<ListFindingAggregationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AggregationResponse> responses() {
        Function<ListFindingAggregationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.responses() != null) {
                return response.responses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFindingAggregationsResponseFetcher
    implements SyncPageFetcher<ListFindingAggregationsResponse> {
        private ListFindingAggregationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingAggregationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFindingAggregationsResponse nextPage(ListFindingAggregationsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingAggregationsIterable.this.client.listFindingAggregations(ListFindingAggregationsIterable.this.firstRequest);
            }
            return ListFindingAggregationsIterable.this.client.listFindingAggregations((ListFindingAggregationsRequest)((Object)ListFindingAggregationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

